<?php

namespace App\Providers;

use App\Models\Setting;
use Illuminate\Support\ServiceProvider;
use Illuminate\Support\Facades\View;

class AppServiceProvider extends ServiceProvider
{
    /**
     * Register any application services.
     */
    public function register(): void
    {
        //
    }

    /**
     * Bootstrap any application services.
     */
    public function boot(): void
    {
        try {
            $settings = Setting::first();

            View::share('all_settings', $settings);

            if ($settings && $settings->time_zone) {
                config(['app.timezone' => $settings->time_zone]);
                date_default_timezone_set($settings->time_zone); // also set runtime
            }
        } catch (\Exception $e) {
            // Table might not exist during migrations
            View::share('all_settings', null);
        }
    }
}
