<?php

use Illuminate\Database\Migrations\Migration;
use Illuminate\Database\Schema\Blueprint;
use Illuminate\Support\Facades\Schema;

return new class extends Migration
{
    /**
     * Run the migrations.
     */
    public function up(): void
    {
        Schema::create('settings', function (Blueprint $table) {
            $table->id();
            $table->string('company_name');
            $table->string('time_zone')->default('Asia/Dhaka');
            $table->string('currency')->default('USD');
            $table->string('logo_path')->nullable();
            $table->enum('pos_price_type', ['fixed', 'percentage'])->default('fixed');
            $table->decimal('pos_price_value', 10, 2)->default(0.00);
            $table->timestamps();
        });
    }

    /**
     * Reverse the migrations.
     */
    public function down(): void
    {
        Schema::dropIfExists('settings');
    }
};
