<?php

use Illuminate\Database\Migrations\Migration;
use Illuminate\Database\Schema\Blueprint;
use Illuminate\Support\Facades\Schema;

return new class extends Migration
{
    /**
     * Run the migrations.
     */
    public function up(): void
    {
        Schema::table('settings', function (Blueprint $table) {
            // WhatsApp Management Settings
            $table->string('whatsapp_country_code')->default('+880');
            $table->string('whatsapp_api_url')->nullable();
            $table->string('whatsapp_api_token')->nullable();
            $table->text('whatsapp_welcome_message')->nullable();
            $table->text('whatsapp_payment_reminder_message')->nullable();
            $table->text('whatsapp_delivery_message')->nullable();
            $table->text('whatsapp_thank_you_message')->nullable();
            $table->boolean('whatsapp_auto_format_numbers')->default(true);
            $table->integer('whatsapp_retry_attempts')->default(3);
            $table->boolean('whatsapp_include_business_hours')->default(false);
            $table->string('whatsapp_business_hours')->nullable();
        });
    }

    /**
     * Reverse the migrations.
     */
    public function down(): void
    {
        Schema::table('settings', function (Blueprint $table) {
            $table->dropColumn([
                'whatsapp_country_code',
                'whatsapp_api_url',
                'whatsapp_api_token',
                'whatsapp_welcome_message',
                'whatsapp_payment_reminder_message',
                'whatsapp_delivery_message',
                'whatsapp_thank_you_message',
                'whatsapp_auto_format_numbers',
                'whatsapp_retry_attempts',
                'whatsapp_include_business_hours',
                'whatsapp_business_hours'
            ]);
        });
    }
};
