<?php

use Illuminate\Database\Migrations\Migration;
use Illuminate\Database\Schema\Blueprint;
use Illuminate\Support\Facades\Schema;

return new class extends Migration
{
    /**
     * Run the migrations.
     */
    public function up(): void
    {
        Schema::table('settings', function (Blueprint $table) {
            $table->boolean('whatsapp_connected')->default(false);
            $table->string('whatsapp_connected_phone')->nullable();
            $table->string('whatsapp_device_name')->nullable();
            $table->timestamp('whatsapp_connected_at')->nullable();
            $table->string('whatsapp_session_id')->nullable();
        });
    }

    /**
     * Reverse the migrations.
     */
    public function down(): void
    {
        Schema::table('settings', function (Blueprint $table) {
            $table->dropColumn([
                'whatsapp_connected',
                'whatsapp_connected_phone',
                'whatsapp_device_name',
                'whatsapp_connected_at',
                'whatsapp_session_id'
            ]);
        });
    }
};
