<?php

namespace Database\Seeders;

use Illuminate\Database\Seeder;
use Illuminate\Support\Facades\DB;

class ModelsTableSeeder extends Seeder
{
    /**
     * Run the database seeds.
     */
    public function run(): void
    {
        $models = [
            // Apple models
            ['tenant_id' => 1, 'brand_id' => 1, 'name' => 'iPhone 12', 'created_at' => now(), 'updated_at' => now()],
            ['tenant_id' => 1, 'brand_id' => 1, 'name' => 'iPhone 13', 'created_at' => now(), 'updated_at' => now()],
            ['tenant_id' => 1, 'brand_id' => 1, 'name' => 'iPhone 14', 'created_at' => now(), 'updated_at' => now()],
            ['tenant_id' => 1, 'brand_id' => 1, 'name' => 'iPhone 15', 'created_at' => now(), 'updated_at' => now()],
            ['tenant_id' => 1, 'brand_id' => 1, 'name' => 'iPhone SE', 'created_at' => now(), 'updated_at' => now()],

            // Samsung models
            ['tenant_id' => 1, 'brand_id' => 2, 'name' => 'Galaxy S21', 'created_at' => now(), 'updated_at' => now()],
            ['tenant_id' => 1, 'brand_id' => 2, 'name' => 'Galaxy S22', 'created_at' => now(), 'updated_at' => now()],
            ['tenant_id' => 1, 'brand_id' => 2, 'name' => 'Galaxy S23', 'created_at' => now(), 'updated_at' => now()],
            ['tenant_id' => 1, 'brand_id' => 2, 'name' => 'Galaxy Note 20', 'created_at' => now(), 'updated_at' => now()],
            ['tenant_id' => 1, 'brand_id' => 2, 'name' => 'Galaxy A52', 'created_at' => now(), 'updated_at' => now()],

            // Google models
            ['tenant_id' => 1, 'brand_id' => 3, 'name' => 'Pixel 6', 'created_at' => now(), 'updated_at' => now()],
            ['tenant_id' => 1, 'brand_id' => 3, 'name' => 'Pixel 7', 'created_at' => now(), 'updated_at' => now()],
            ['tenant_id' => 1, 'brand_id' => 3, 'name' => 'Pixel 8', 'created_at' => now(), 'updated_at' => now()],
            ['tenant_id' => 1, 'brand_id' => 3, 'name' => 'Pixel 6a', 'created_at' => now(), 'updated_at' => now()],

            // OnePlus models
            ['tenant_id' => 1, 'brand_id' => 4, 'name' => 'OnePlus 9', 'created_at' => now(), 'updated_at' => now()],
            ['tenant_id' => 1, 'brand_id' => 4, 'name' => 'OnePlus 10', 'created_at' => now(), 'updated_at' => now()],
            ['tenant_id' => 1, 'brand_id' => 4, 'name' => 'OnePlus 11', 'created_at' => now(), 'updated_at' => now()],
            ['tenant_id' => 1, 'brand_id' => 4, 'name' => 'OnePlus Nord', 'created_at' => now(), 'updated_at' => now()],

            // Huawei models
            ['tenant_id' => 1, 'brand_id' => 5, 'name' => 'P40', 'created_at' => now(), 'updated_at' => now()],
            ['tenant_id' => 1, 'brand_id' => 5, 'name' => 'P50', 'created_at' => now(), 'updated_at' => now()],
            ['tenant_id' => 1, 'brand_id' => 5, 'name' => 'Mate 40', 'created_at' => now(), 'updated_at' => now()],
            ['tenant_id' => 1, 'brand_id' => 5, 'name' => 'Nova 9', 'created_at' => now(), 'updated_at' => now()],

            // Xiaomi models
            ['tenant_id' => 1, 'brand_id' => 6, 'name' => 'Mi 11', 'created_at' => now(), 'updated_at' => now()],
            ['tenant_id' => 1, 'brand_id' => 6, 'name' => 'Mi 12', 'created_at' => now(), 'updated_at' => now()],
            ['tenant_id' => 1, 'brand_id' => 6, 'name' => 'Redmi Note 11', 'created_at' => now(), 'updated_at' => now()],
            ['tenant_id' => 1, 'brand_id' => 6, 'name' => 'Poco X3', 'created_at' => now(), 'updated_at' => now()],

            // Sony models
            ['tenant_id' => 1, 'brand_id' => 7, 'name' => 'Xperia 5 III', 'created_at' => now(), 'updated_at' => now()],
            ['tenant_id' => 1, 'brand_id' => 7, 'name' => 'Xperia 1 III', 'created_at' => now(), 'updated_at' => now()],
            ['tenant_id' => 1, 'brand_id' => 7, 'name' => 'Xperia 10 III', 'created_at' => now(), 'updated_at' => now()],

            // LG models
            ['tenant_id' => 1, 'brand_id' => 8, 'name' => 'Velvet', 'created_at' => now(), 'updated_at' => now()],
            ['tenant_id' => 1, 'brand_id' => 8, 'name' => 'Wing', 'created_at' => now(), 'updated_at' => now()],
            ['tenant_id' => 1, 'brand_id' => 8, 'name' => 'G8 ThinQ', 'created_at' => now(), 'updated_at' => now()],

            // Nokia models
            ['tenant_id' => 1, 'brand_id' => 9, 'name' => '3310', 'created_at' => now(), 'updated_at' => now()],
            ['tenant_id' => 1, 'brand_id' => 9, 'name' => 'X20', 'created_at' => now(), 'updated_at' => now()],
            ['tenant_id' => 1, 'brand_id' => 9, 'name' => 'G20', 'created_at' => now(), 'updated_at' => now()],
            ['tenant_id' => 1, 'brand_id' => 9, 'name' => 'C20', 'created_at' => now(), 'updated_at' => now()],

            // Motorola models
            ['tenant_id' => 1, 'brand_id' => 10, 'name' => 'Edge 20', 'created_at' => now(), 'updated_at' => now()],
            ['tenant_id' => 1, 'brand_id' => 10, 'name' => 'Moto G Stylus', 'created_at' => now(), 'updated_at' => now()],
            ['tenant_id' => 1, 'brand_id' => 10, 'name' => 'Razr 5G', 'created_at' => now(), 'updated_at' => now()],
        ];

        DB::table('mobile_models')->insert($models);
    }
}
