@extends('layouts.app')
@push('style')
@endpush
@section('main')
    {{-- {{ $brands }} --}}
    <!-- Content Header (Page header) -->
    <section class="content-header">
        <section class="container-fluid">
            <div class="row mb-2">
                <div class="col-sm-6">
                    <h1>Product Stock</h1>
                </div>
                <div class="col-sm-6">
                    <ol class="breadcrumb float-sm-right">
                        <li class="breadcrumb-item"><a href="#">Home</a></li>
                        <li class="breadcrumb-item active">Project Add</li>
                    </ol>
                </div>
            </div>
        </section><!-- /.container-fluid -->
        {{-- =============================================== --}}
        @if (session('success'))
            <div class="alert alert-success">
                {{ session('success') }}
            </div>
        @endif
        {{-- =============================================== --}}
    </section>
    {{-- {{ $products }} --}}
    <!-- Main content -->
    <section class="content">
        <div class="card">
            <div class="card-header border-0">
                <h3 class="card-title">Products</h3>
                <div class="card-tools">
                    <a href="#" class="btn btn-tool btn-sm">
                        <i class="fas fa-download"></i>
                    </a>
                    <a href="#" class="btn btn-tool btn-sm">
                        <i class="fas fa-bars"></i>
                    </a>
                </div>
            </div>
            <div class="card-body">
                <div class="row mb-3">
                    <div class="col-md-3">
                        <div class="info-box">
                            <span class="info-box-icon bg-success"><i class="fas fa-box"></i></span>
                            <div class="info-box-content">
                                <span class="info-box-text">NEW PHONES</span>
                                <span class="info-box-number">Stock:
                                    {{ $products->where('condition', 'new')->count() }}</span>
                            </div>
                        </div>
                    </div>
                    <div class="col-md-3">
                        <div class="info-box">
                            <span class="info-box-icon bg-warning"><i class="fas fa-box-open"></i></span>
                            <div class="info-box-content">
                                <span class="info-box-text">OLD PHONES</span>
                                <span class="info-box-number">Stock:
                                    {{ $products->where('condition', 'old')->count() }}</span>
                            </div>
                        </div>
                    </div>
                    <div class="col-md-3">
                        <div class="info-box">
                            <span class="info-box-icon bg-info"><i class="fas fa-cubes"></i></span>
                            <div class="info-box-content">
                                <span class="info-box-text">TOTAL STOCK</span>
                                <span class="info-box-number">{{ count($products) }}</span>
                            </div>
                        </div>
                    </div>
                    <div class="col-md-3">
                        <div class="info-box">
                            <span class="info-box-icon bg-info"><i class="fas fa-cubes"></i></span>
                            <div class="info-box-content">
                                <span class="info-box-text">TOTAL STOCK PRICE</span>
                                <span class="info-box-number">{{ env('APP_CURRENCY') }} {{ $totalCost }}</span>

                            </div>
                        </div>
                    </div>
                </div>

                <div class="card">
                    <div class="card-header">
                        <h3 class="card-title">Product Stock</h3>
                    </div>
                    <div class="card-body">
                        <table id="data_table" class="table table-bordered table-striped">
                            <thead>
                                <th>#</th>
                                <th>Customer Info</th>
                                <th>Brand</th>
                                <th>Model</th>
                                <th>IMEI/SN</th>
                                <th>Condition</th>
                                <th>Stock</th>
                                <th>Color</th>
                                <th>GB</th>
                                <th>Buy Price</th>
                                <th>Last Updated</th>
                                <th>Action</th> <!-- Added Action column -->
                                </tr>
                            </thead>
                            <tbody>

                                @foreach ($products as $product)
                                    <tr>
                                        <td>{{ $product->id }}</td>
                                        <td>
                                            Name:- {{ $product->customer->name }},
                                            Number:- {{ $product->customer->number }},
                                            cpr:- {{ $product->customer->cpr }},
                                            address:- {{ $product->customer->address }}
                                        </td>
                                        <td>{{ $product->brand }}</td>
                                        <td>{{ $product->model }}</td>
                                        <td>{{ $product->imei_or_sn }}</td>
                                        <td>{{ $product->condition }}</td>
                                        <td>{{ $product->stock }}</td>
                                        <td>{{ $product->color }}</td>
                                        <td>{{ $product->gb }}</td>
                                        <td>{{ $product->buy_price }}</td>
                                        <td>{{ $product->id }}</td>
                                        <td>
                                            <div class="btn-group">
                                                <button type="button" class="btn btn-info">Action</button>
                                                <button type="button"
                                                    class="btn btn-info dropdown-toggle dropdown-hover dropdown-icon"
                                                    data-toggle="dropdown" aria-expanded="false">
                                                    <span class="sr-only">Toggle Dropdown</span>
                                                </button>
                                                <div class="dropdown-menu" role="menu">
                                                    <a class="dropdown-item"
                                                        href="{{ route('product.edit', $product->id) }}">Edit</a>
                                                    <a class="dropdown-item"
                                                        href="{{ route('product.print', $product->id) }}"
                                                        target="_blank">Print Receipt</a>
                                                    <form action="{{ route('product.destroy', $product->id) }}"
                                                        method="POST">
                                                        @csrf
                                                        @method('DELETE')
                                                        <button type="submit" class="dropdown-item text-danger"
                                                            onclick="return confirm('Are you sure you want to delete this product?');">Delete</button>
                                                    </form>
                                                </div>

                                            </div>
                                        </td>
                                    </tr>
                                @endforeach

                            </tbody>
                            <tfoot>
                                <tr>
                                    <th>#</th>
                                    <th>Customer Info</th>
                                    <th>Brand</th>
                                    <th>Model</th>
                                    <th>IMEI/SN</th>
                                    <th>Condition</th>
                                    <th>Stock</th>
                                    <th>Color</th>
                                    <th>GB</th>
                                    <th>Buy Price</th>
                                    <th>Last Updated</th>
                                    <th>Action</th> <!-- Added Action column -->
                                </tr>
                            </tfoot>
                        </table>
                    </div>
                </div>

            </div>
        </div>
    </section>
@endsection

@push('script')
    <script>
        $(function() {
            $("#data_table").DataTable({
                "responsive": true,
                "lengthChange": false,
                "autoWidth": false,
                "buttons": ["copy", "csv", "excel", "pdf", "print", "colvis"]
            }).buttons().container().appendTo('#example1_wrapper .col-md-6:eq(0)');

        });
        $(document).ready(function() {});
    </script>
@endpush
