@extends('layouts.app')

@section('content')
<div class="container">
    <h2>Edit Expense</h2>
    <form action="{{ route('expenses.update', $expense->id) }}" method="POST">
  
        @method('PUT')
        <div class="form-group">
            <label for="expense_date">Expense Date *</label>
            <input type="date" name="expense_date" id="expense_date" class="form-control" value="{{ $expense->expense_date }}" required>
        </div>

        <div class="form-group">
            <label for="category">Category *</label>
            <select name="category" id="category" class="form-control" required>
                <option value="Food" {{ $expense->category == 'Food' ? 'selected' : '' }}>Food</option>
                <option value="Transport" {{ $expense->category == 'Transport' ? 'selected' : '' }}>Transport</option>
                <option value="Accommodation" {{ $expense->category == 'Accommodation' ? 'selected' : '' }}>Accommodation</option>
            </select>
        </div>

        <div class="form-group">
            <label for="expense_for">Expense For *</label>
            <input type="text" name="expense_for" id="expense_for" class="form-control" value="{{ $expense->expense_for }}" required>
        </div>

        <div class="form-group">
            <label for="amount">Amount *</label>
            <input type="number" name="amount" id="amount" class="form-control" value="{{ $expense->amount }}" required>
        </div>

        <div class="form-group">
            <label for="reference_no">Reference No.</label>
            <input type="text" name="reference_no" id="reference_no" class="form-control" value="{{ $expense->reference_no }}">
        </div>

        <div class="form-group">
            <label for="note">Note</label>
            <textarea name="note" id="note" class="form-control">{{ $expense->note }}</textarea>
        </div>

        <button type="submit" class="btn btn-success">Save Changes</button>
        <a href="{{ route('expenses.index') }}" class="btn btn-warning">Close</a>
    </form>
</div>

