@extends('layouts.app')

@section('main')
    <!-- Content Hea                                                    <span class="info-box-text">Total Accessories</span>
                            <span class="info-box-number" id="total-accessories">
                                {{ \App\Models\Product::where('tenant_id', app('tenant')->id)->where('type', 'Accessories')->count() }}
                            </span>              <span class="info-box-text">Total Phones</span>
                            <span class="info-box-number" id="total-phones">
                                {{ \App\Models\Product::where('tenant_id', app('tenant')->id)->where('type', 'Phone')->count() }}
                            </span>              <span class="info-box-text">Total Products</span>
                            <span class="info-box-number" id="total-records">
                                {{ \App\Models\Product::where('tenant_id', app('tenant')->id)->count() }}
                            </span>r (Page header) -->
    <section class="content-header">
        <div class="container-fluid">
            <div class="row mb-2">
                <div class="col-sm-6">
                    <h1><i class="fas fa-cube"></i> Products Management</h1>
                </div>
                <div class="col-sm-6">
                    <ol class="breadcrumb float-sm-right">
                        <li class="breadcrumb-item"><a href="{{ route('home') }}">Home</a></li>
                        <li class="breadcrumb-item active">Products</li>
                    </ol>
                </div>
            </div>
        </div>
        
        @if (session('success'))
            <div class="alert alert-success alert-dismissible fade show">
                <button type="button" class="close" data-dismiss="alert">&times;</button>
                <i class="fas fa-check-circle"></i> {{ session('success') }}
            </div>
        @endif
        @if (session('error'))
            <div class="alert alert-danger alert-dismissible fade show">
                <button type="button" class="close" data-dismiss="alert">&times;</button>
                <i class="fas fa-exclamation-circle"></i> {{ session('error') }}
            </div>
        @endif
    </section>

    <!-- Main content -->
    <section class="content">
        <x-admin-table 
            title="All Products"
            :create-route="route('product.create')"
            create-text="Add Product"
            :ajax-url="route('product.index')"
            table-id="products-table"
            :show-search="true"
            :show-date-filter="true"
            :show-export="true"
            :columns="[
                ['title' => 'SL', 'field' => 'sl', 'orderable' => false],
                ['title' => 'Type', 'field' => 'type'],
                ['title' => 'Name', 'field' => 'name'],
                ['title' => 'Brand', 'field' => 'brand'],
                ['title' => 'Model', 'field' => 'model'],
                ['title' => 'IMEI/SN', 'field' => 'imei_or_sn'],
                ['title' => 'Condition', 'field' => 'condition'],
                ['title' => 'Stock', 'field' => 'stock'],
                ['title' => 'Buy Price', 'field' => 'buy_price'],
                ['title' => 'Sell Price', 'field' => 'sell_price'],
                ['title' => 'Added Date', 'field' => 'created_at'],
                ['title' => 'Actions', 'field' => 'actions', 'orderable' => false, 'searchable' => false]
            ]"
        >
            <x-slot name="customInfoBoxes">
                <div class="row mb-3">
                    <div class="col-md-4">
                        <div class="info-box">
                            <span class="info-box-icon bg-info"><i class="fas fa-cube"></i></span>
                            <div class="info-box-content">
                                <span class="info-box-text">Total Products</span>
                                <span class="info-box-number" id="total-records">{{ $totalProducts ?? 0 }}</span>
                            </div>
                        </div>
                    </div>
                    <div class="col-md-4">
                        <div class="info-box">
                            <span class="info-box-icon bg-primary"><i class="fas fa-warehouse"></i></span>
                            <div class="info-box-content">
                                <span class="info-box-text">Stock Phones</span>
                                <span class="info-box-number" id="stock-phones">{{ $stockPhones ?? 0 }}</span>
                            </div>
                        </div>
                    </div>
                    <div class="col-md-4">
                        <div class="info-box">
                            <span class="info-box-icon bg-secondary"><i class="fas fa-box"></i></span>
                            <div class="info-box-content">
                                <span class="info-box-text">Stock Accessories</span>
                                <span class="info-box-number" id="stock-accessories">{{ $stockAccessories ?? 0 }}</span>
                            </div>
                        </div>
                    </div>
                </div>
            </x-slot>

            <x-slot name="extraFilters">
                <div class="col-md-3">
                    <label for="condition_filter" class="form-label">Condition</label>
                    <select class="form-control" id="condition_filter" name="condition_filter">
                        <option value="">All Conditions</option>
                        @foreach($conditions as $condition)
                            <option value="{{ $condition }}">{{ ucfirst($condition) }}</option>
                        @endforeach
                    </select>
                </div>
                
                <div class="col-md-3">
                    <label for="stock_filter" class="form-label">Stock Status</label>
                    <select class="form-control" id="stock_filter" name="stock_filter">
                        <option value="">All Stock</option>
                        <option value="in_stock">In Stock</option>
                        <option value="low_stock">Low Stock (≤5)</option>
                        <option value="out_of_stock">Out of Stock</option>
                    </select>
                </div>
            </x-slot>
        </x-admin-table>
    </section>
@endsection

@push('script')
    <script>
        // $(function() {
        //     // $("#data_table").DataTable({
        //     //     "responsive": true,
        //     //     "lengthChange": true,
        //     //     "autoWidth": false,
        //     //     "buttons": ["copy", "csv", "excel", "pdf", "print", "colvis"]
        //     // }).buttons().container().appendTo('#data_table_wrapper .col-md-6:eq(0)');
        //     $('#data_table').DataTable({
        //         "paging": true,
        //         "lengthChange": false,
        //         "searching": false,
        //         "ordering": true,
        //         "info": true,
        //         "autoWidth": false,
        //         "responsive": true,
        //     });
        // });
        $(function() {
            $('#data_table').DataTable({
                processing: true,
                serverSide: true,
                ajax: {
                    url: '{{ route("product.index") }}',
                    type: 'GET',
                    error: function(xhr, error, thrown) {
                        console.log('Ajax Error:', xhr.responseText);
                        alert('Error loading data: ' + xhr.responseText);
                    }
                },
                columns: [
                    { data: 'id' },
                    { data: 'type' },
                    { data: 'name' },
                    { data: 'brand' },
                    { data: 'model' },
                    { data: 'imei_or_sn' },
                    { data: 'condition' },
                    { data: 'stock' },
                    { data: 'buy_price' },
                    { data: 'sell_price' },
                    { data: 'actions', orderable: false, searchable: false }
                ],
                responsive: true,
                lengthChange: false,
                autoWidth: false,
                buttons: ["copy", "csv", "excel", "pdf", "print", "colvis"]
            }).buttons().container().appendTo('#data_table_wrapper .col-md-6:eq(0)');
        });
    </script>
@endpush
