@extends('layouts.app')

@section('main')
    <section class="content-header">
        <div class="container-fluid">
            <div class="row mb-2">
                <div class="col-sm-6">
                    <h1>Invoice</h1>
                </div>
                <div class="col-sm-6 d-flex justify-content-end">
                    <button onclick="window.print();" class="btn btn-primary">Print Invoice</button>
                </div>
            </div>
        </div>
    </section>

    <div class="invoice p-3 mb-3">
        <div class="row">
            <div class="col-12">
                <h4>
                    <i class="fas fa-globe"></i> Sales Invoice
                    <small class="float-right">Date:
                        {{ \Carbon\Carbon::parse($sale->sale_date)->format('Y-m-d') }}</small>
                </h4>
            </div>
        </div>

        <div class="row invoice-info">
            <div class="col-sm-4 invoice-col">
                From
                <address>
                    <strong>Your Company, Inc.</strong><br>
                    123 Your Street<br>
                    Your City, Your Country<br>
                    Phone: (555) 555-5555<br>
                    Email: info@yourcompany.com
                </address>
            </div>
            <div class="col-sm-4 invoice-col">
                To
                <address>
                    <strong>{{ $sale->customer_name }}</strong><br>
                    Phone: {{ $sale->customer_mobile }}<br>
                </address>
            </div>
            <div class="col-sm-4 invoice-col">
                <b>Invoice #{{ $sale->id }}</b><br>
                <br>
                <b>Sale Date:</b> {{ \Carbon\Carbon::parse($sale->sale_date)->format('Y-m-d') }}<br>
            </div>
        </div>

        <div class="row">
            <div class="col-12 table-responsive">
                <table class="table table-striped">
                    <thead>
                        <tr>
                            <th>Brand</th>
                            <th>Model</th>
                            <th>IMEI/SN</th>
                            <th>Selling Price</th>
                            <th>Quantity</th>
                            <th>Total Amount</th>
                            <th>Profit</th>
                        </tr>
                    </thead>
                    <tbody>
                        <tr>
                            <td>{{ $sale->product->brand }}</td>
                            <td>{{ $sale->product->model }}</td>
                            <td>{{ $sale->product->imei_or_sn }}</td>
                            <td>{{ env('APP_CURRENCY') . number_format($sale->sell_price, 2) }}</td>
                            <td>{{ $sale->sold_quantity }}</td>
                            <td>{{ env('APP_CURRENCY') . number_format($sale->sell_price * $sale->sold_quantity, 2) }}
                            </td>
                            <td>{{ env('APP_CURRENCY') . number_format($sale->profit, 2) }}</td>
                        </tr>
                    </tbody>
                </table>
            </div>
        </div>

        <div class="row no-print">
            <div class="col-12">
                <button onclick="window.print();" class="btn btn-primary float-right"><i class="fas fa-print"></i>
                    Print</button>
            </div>
        </div>
    </div>
@endsection
