@extends('layouts.app')
@push('style')
    <style>
        /* Style for the search results dropdown */
        #customer_results {
            position: absolute;
            z-index: 1000;
            /* Ensure it appears above other elements */
            background-color: #fff;
            border: 1px solid #ccc;
            border-top: none;
            max-height: 200px;
            overflow-y: auto;
            width: 100%;
            /* Match the width of the input field */
            box-shadow: 0 4px 8px rgba(0, 0, 0, 0.1);
        }

        /* Style for individual search items */
        .search-item {
            padding: 8px 12px;
            cursor: pointer;
            list-style-type: none;
            /* Remove bullet points */
        }

        .search-item:hover {
            background-color: #f8f9fa;
            /* Highlight on hover */
        }

        /* Hide the dropdown by default */
        #customer_results {
            display: none;
        }
    </style>
@endpush
@section('main')
    <div class="container">
        <h1>Sell Product</h1>

        @if (session('error'))
            <div class="alert alert-danger">{{ session('error') }}</div>
        @endif

        <p><strong>Brand:</strong> {{ $product->ProductBrand->name }}</p>
        <p><strong>Model:</strong> {{ $product->ProductModel->name }}</p>
        <p><strong>Stock:</strong> {{ $product->stock }}</p>

        <form action="{{ route('sell.process', $product->id) }}" method="POST">
            @csrf
            <label>Customer Name:</label>
            <input type="text" class="form-control" name="customer_name" id="customer_search" required><br>
            <div id="customer_results" class="search-results"></div> <!-- Dropdown for results -->
            <button type="button" data-toggle="modal" data-target="#modal-add-customer" class="btn btn-block">
                <i class="fas fa-plus"></i> Add New Customer
            </button>
            <label>Customer Mobile:</label>
            <input type="text" class="form-control" name="customer_mobile"><br>

            <label>Selling Price:</label>
            <input type="number" step="0.01" class="form-control" name="sell_price" required><br>

            <label>Quantity Sold:</label>
            <input type="number" class="form-control" name="sold_quantity" required><br>

            <label>Warranty:</label>
            <select class="form-control" name="warranty" id="warranty">
                <option value="No Warranty">No Warranty</option>
                <option value="1 Day">1 Day</option>
                <option value="7 Days">7 Days</option>
                <option value="1 Month">1 Month</option>
                <option value="3 Months">3 Months</option>
                <option value="6 Months">6 Months</option>
                <option value="1 Year">1 Year</option>
                <option value="Custom">Custom</option>
            </select><br>

            <div id="customWarranty" style="display: none;">
                <label>Custom Warranty Value:</label>
                <input type="number" name="custom_warranty_value"><br>
                <label>Custom Warranty Unit:</label>
                <select name="custom_warranty_unit" class="form-control">
                    <option value="Days">Days</option>
                    <option value="Months">Months</option>
                    <option value="Years">Years</option>
                </select><br>
            </div>

            <input type="submit" class="btn btn-primary" value="Sell">
        </form>
    </div>


    {{-- Add Customer --}}
    <div class="modal fade" id="modal-add-customer">
        <div class="modal-dialog">
            <div class="modal-content">
                <div class="modal-header">
                    <h4 class="modal-title">Add New Customer</h4>
                    <button type="button" class="close" data-dismiss="modal" aria-label="Close">
                        {{-- <span aria-hidden="true">&times;</span> --}}
                    </button>
                </div>
                <form id="customer_form">
                    @csrf <!-- CSRF Token -->
                    <div class="modal-body">
                        <label for="customer_name">Customer Name:</label>
                        <input type="text" id="customer_name" class="form-control" name="customer_name" required>

                        <label for="customer_number">Customer Number:</label>
                        <input type="tel" id="customer_number" class="form-control" name="customer_number" required>

                        <label for="customer_cpr">Customer CPR:</label>
                        <input type="text" id="customer_cpr" class="form-control" name="customer_cpr">

                        <label for="address">Address:</label>
                        <input type="text" id="address" class="form-control" name="address">

                        <div class="modal-footer">
                            <button type="button" class="btn btn-default" data-dismiss="modal">Close</button>
                            <button type="submit" class="btn btn-primary">Save Customer</button>
                        </div>
                    </div>
                </form>
            </div>
        </div>
    </div>
    {{-- Add Customer --}}

    <script>
        document.getElementById("warranty").addEventListener("change", function() {
            document.getElementById("customWarranty").style.display = this.value === "Custom" ? "block" : "none";
        });
    </script>
@endsection


@push('script')
    <script>
        // +++++++++++++++++++++++++   ( 2 )    ++++++++++++++++++++++++++++++++++++++++
        $('#customer_form').on('submit', function(e) {
            e.preventDefault(); // Prevent default form submission

            $.ajax({
                url: "{{ route('customer.store') }}",
                type: "POST",
                data: $(this).serialize(),
                success: function(response, status, xhr) {
                    if (xhr.status === 201) { // HTTP 201 Created
                        $('#customer_form')[0].reset(); // Reset the form
                        $('#modal-add-customer').modal('hide'); // Hide modal
                        alert(response.message);
                    } else {
                        console.log("Unexpected response status: " + xhr.status);
                    }
                },
                error: function(xhr) {
                    if (xhr.status === 422) { // Validation error
                        let errors = xhr.responseJSON.errors;
                        let errorMessages = Object.values(errors).flat().join("\n");
                        alert("Validation Error:\n" + errorMessages);
                    } else if (xhr.status === 500) { // Server error
                        alert("Server Error! Please try again.");
                    } else {
                        alert("An error occurred. Status: " + xhr.status);
                    }
                    console.log(xhr.responseText);
                }
            });
        });
        // +++++++++++++++++++++++++   ( 2 )    ++++++++++++++++++++++++++++++++++++++++
        // +++++++++++++++++++++++++   ( 1 )    ++++++++++++++++++++++++++++++++++++++++
        $("#customer_search").on("keyup", function() {
            let query = $(this).val().trim();
            if (query.length < 2) {
                $("#customer_results").html("").hide(); // Hide if query is too short
                return;
            }

            $.ajax({
                url: "{{ route('api.customers.search') }}",
                type: "GET",
                data: {
                    query: query
                },
                success: function(response) {
                    let resultHTML = "";
                    if (response.length > 0) {
                        resultHTML += '<ul class="">';
                        $.each(response, function(index, customer) {
                            resultHTML += `<li class=" search-item" data-id="${customer.id}" data-name="${customer.name}" data-number="${customer.number}">
                            <strong>${customer.name}</strong> - ${customer.number}
                        </li>`;
                        });
                        resultHTML += '</ul>';
                    } else {
                        resultHTML =
                            '<p class="dropdown-item text-muted">No results found</p>';
                    }

                    $("#customer_results").html(resultHTML).show(); // Show results
                }
            });
        });

        // Handle selection
        $(document).on("click", ".search-item", function() {
            let customerId = $(this).data("id");
            let customerName = $(this).data("name");
            let customerNumber = $(this).data("number");

            $("#customer_search").val(`${customerName} (${customerNumber})`);
            $("#customer_info").val(customerId); // Store customer ID
            $("#customer_results").hide(); // Hide dropdown after selection
        });

        // Hide dropdown on clicking outside
        $(document).on("click", function(e) {
            if (!$(e.target).closest("#customer_search, #customer_results").length) {
                $("#customer_results").hide();
            }
        });
    </script>
@endpush
