<?php
// app/Http/Controllers/ReportController.php
namespace App\Http\Controllers;

use App\Models\TotalReport;

class ReportController extends Controller
{
    // Method to show the merged report
    public function showReport()
    {
        // Fetch the merged report data
        $reportData = TotalReport::getMergedReport();

        // Calculate the totals
        $totalSales = $reportData->sum('total_sales') + $reportData->sum('total_direct_sales'); // Sum of total sales + total direct sales
        $totalProfit = $reportData->sum('total_profit');
        $totalExpenses = $reportData->sum('total_expenses');
        $totalDirectProfit = $reportData->sum('total_direct_profit');
        
        // Main Profit calculation (Total Profit + Direct Profit - Total Expenses)
        $mainProfit = $totalProfit + $totalDirectProfit - $totalExpenses;

        // Return the view with the report data and totals
        return view('report.netprofit', compact('reportData', 'totalSales', 'totalProfit', 'totalExpenses', 'mainProfit', 'totalDirectProfit'));
    }
    
}

