<?php

namespace App\Models;

use Illuminate\Database\Eloquent\Model;

class Brand extends Model
{
    protected $fillable = [
        'name',
        'tenant_id'
    ];

    public function models()
    {
        return $this->hasMany(MobileModel::class);
    }

    public function resolveRouteBinding($value, $field = null)
    {
        $tenantId = session('tenant_id', 1);
        return $this->where('tenant_id', $tenantId)->findOrFail($value);
    }
}
