<?php

namespace App\Models;

use Illuminate\Database\Eloquent\Model;
use Illuminate\Support\Facades\DB;

class SalesReport extends Model
{
    public static function getReport($startDate, $endDate)
    {
        // Query to calculate only Direct Profit
        $query = DB::table('direct_sales as ds')
            ->select(
                'ds.product_type',
                DB::raw('SUM(ds.direct_profit) AS total_direct_profit')
            )
            ->whereBetween('ds.created_at', [$startDate, $endDate])
            ->groupBy('ds.product_type') // Group by product type
            ->orderByDesc('total_direct_profit'); // Order by total profit

        \Log::info($query->toSql(), $query->getBindings());

        return $query->get();
    }
}
