<?php

namespace App\Models;

use Illuminate\Database\Eloquent\Model;

class Setting extends Model
{
    protected $fillable = [
        'company_name',
        'company_registration_name',
        'number',
        'address',
        'company_registration_number',
        'company_email',
        'website',
        'logo_path',
        'time_zone',
        'currency',
        'pos_price_type',
        'pos_price_value',
        'tenant_id',
        // Invoice settings
        'invoice_header_text',
        'invoice_footer_text',
        'invoice_template',
        'invoice_terms_conditions',
        // WhatsApp settings
        'whatsapp_enabled',
        'auto_send_whatsapp',
        'include_company_logo',
        'include_qr_code',
        'whatsapp_country_code',
        'whatsapp_welcome_message',
        'whatsapp_payment_reminder_message',
        'whatsapp_delivery_message',
        'whatsapp_thank_you_message',
        'whatsapp_invoice_message_template',
        'whatsapp_auto_format_numbers',
        'whatsapp_retry_attempts',
        'whatsapp_include_business_hours',
        'whatsapp_business_hours',
        'whatsapp_api_url',
        'whatsapp_api_token',
        'whatsapp_phone_number',
        'whatsapp_connection_status',
        'whatsapp_qr_code',
        'whatsapp_session_status',
    ];

    public function tenant()
    {
        return $this->belongsTo(Tenant::class);
    }

    protected static function booted()
    {
        static::addGlobalScope('tenant', function ($builder) {
            if (app()->has('tenant')) {
                $builder->where('tenant_id', app('tenant')->id);
            }
        });
    }
}
