<?php

namespace App\Providers;

use Spatie\Permission\Contracts\PermissionsTeamResolver;

class TenantResolver implements PermissionsTeamResolver
{
    public function getPermissionsTeamId(): int|string|null
    {
        return session('tenant_id', 1); // Default to 1 if not set
    }

    public function setPermissionsTeamId($id): void
    {
        session(['tenant_id' => $id]);
    }
}
