<?php

use Illuminate\Database\Migrations\Migration;
use Illuminate\Database\Schema\Blueprint;
use Illuminate\Support\Facades\DB;
use Illuminate\Support\Facades\Schema;

return new class extends Migration
{
    /**
     * Run the migrations.
     */
    public function up(): void
    {
        Schema::create('products', function (Blueprint $table) {
            $table->id(); // Primary key: id (auto-incrementing)
            $table->string('name'); // brand: varchar(255)
            $table->string('type'); // brand: varchar(255)
            $table->decimal('buy_price', 10, 2); // buy_price: decimal(10,2)
            $table->text('customer_info')->nullable(); // customer_info: text, nullable
            $table->string('brand')->nullable(); // brand: varchar(255)
            $table->string('model')->nullable(); // model: varchar(255)
            $table->string('imei_or_sn')->nullable(); // imei_or_sn: varchar(255), nullable
            $table->integer('warranty_period')->nullable(); // warranty_period: int, nullable
            $table->string('condition', 50)->nullable(); // condition: varchar(50), nullable
            $table->integer('stock')->default(0); // stock: int, default value 0
            $table->string('customer_mobile', 20)->nullable(); // customer_mobile: varchar(20), nullable
            $table->string('customer_cpr', 50)->nullable(); // customer_cpr: varchar(50), nullable
            $table->string('customer_email', 100)->nullable(); // customer_email: varchar(100), nullable
            $table->string('status', 50)->nullable(); // status: varchar(50), nullable
            $table->string('color', 50)->nullable(); // color: varchar(50), nullable
            $table->integer('gb')->nullable(); // gb: int, nullable
            $table->boolean('visible')->default(1); // visible: tinyint(1), default 1
            $table->timestamp('last_updated')->useCurrent()->onUpdate(DB::raw('CURRENT_TIMESTAMP')); // last_updated: timestamp with automatic current timestamp on update
            $table->timestamps(); // default timestamps (created_at and updated_at)
        });
    }

    /**
     * Reverse the migrations.
     */
    public function down(): void
    {
        Schema::dropIfExists('products');
    }
};
