<?php

use Illuminate\Database\Migrations\Migration;
use Illuminate\Database\Schema\Blueprint;
use Illuminate\Support\Facades\Schema;

return new class extends Migration
{
    /**
     * Run the migrations.
     */
    public function up(): void
    {
        Schema::create('customers', function (Blueprint $table) {
            $table->id(); // Auto-incrementing primary key (equivalent to `id` int(11) AUTO_INCREMENT)
            $table->string('name', 255); // `name` varchar(255)
            $table->string('phone', 20)->unique(); // `phone` varchar(20)
            $table->string('email', 40)->nullable(); // `phone` varchar(20)
            $table->string('cpr', 50)->nullable(); // `cpr` varchar(50), nullable
            $table->text('address')->nullable(); // `address` text, nullable
            $table->timestamps();
        });
    }

    /**
     * Reverse the migrations.
     */
    public function down(): void
    {
        Schema::dropIfExists('customers');
    }
};
