<?php

use Illuminate\Database\Migrations\Migration;
use Illuminate\Database\Schema\Blueprint;
use Illuminate\Support\Facades\Schema;

return new class extends Migration
{
    /**
     * Run the migrations.
     */
    public function up(): void
    {
        Schema::create('locations', function (Blueprint $table) {
            $table->id();
            $table->string('name'); // varchar(255)
            $table->string('location_id', 100)->nullable(); // varchar(100)
            $table->string('city', 100); // varchar(100)
            $table->string('state', 100); // varchar(100)
            $table->string('country', 100); // varchar(100)
            $table->string('zip_code', 20)->nullable(); // varchar(20)
            $table->string('landmark', 255)->nullable(); // varchar(255)
            $table->string('mobile', 20)->nullable(); // varchar(20)
            $table->string('alternate_contact', 20)->nullable(); // varchar(20)
            $table->string('email', 255)->nullable(); // varchar(255)
            $table->string('website', 255)->nullable(); // varchar(255)
            $table->string('business_registration_number', 100)->nullable(); // varchar(100)
            $table->timestamps();
        });
    }

    /**
     * Reverse the migrations.
     */
    public function down(): void
    {
        Schema::dropIfExists('locations');
    }
};
