<?php

use Illuminate\Database\Migrations\Migration;
use Illuminate\Database\Schema\Blueprint;
use Illuminate\Support\Facades\Schema;

return new class extends Migration
{
    /**
     * Run the migrations.
     */
    public function up(): void
    {
        Schema::create('sales', function (Blueprint $table) {
            $table->id();
            $table->unsignedBigInteger('customer_id')->nullable();
            $table->decimal('total_amount', 22, 4)->nullable();
            $table->decimal('discount', 22, 4)->nullable();
            $table->decimal('net_amount', 22, 4)->nullable();
            $table->decimal('paid_amount', 22, 4)->nullable();
            $table->decimal('due_amount', 22, 4)->nullable();
            $table->string('payment_method', 255)->nullable();
            $table->enum('payment_status', ['paid', 'partial', 'unpaid'])->nullable();
            $table->foreign('customer_id')->references('id')->on('customers');
            $table->timestamps();
        });

        // Add foreign key to sell_transactions after both tables are created
        Schema::table('sell_transactions', function (Blueprint $table) {
            $table->foreign('sale_id')->references('id')->on('sales');
        });
    }

    /**
     * Reverse the migrations.
     */
    public function down(): void
    {
        Schema::dropIfExists('sales');
    }
};
