<?php

use Illuminate\Database\Migrations\Migration;
use Illuminate\Database\Schema\Blueprint;
use Illuminate\Support\Facades\Schema;

return new class extends Migration
{
    /**
     * Run the migrations.
     */
    public function up(): void
    {
        Schema::create('contacts', function (Blueprint $table) {
            $table->id();
            $table->string('name', 255)->nullable();
            $table->string('phone', 20)->nullable();
            $table->string('email', 40)->nullable();
            $table->string('cpr', 50)->nullable();
            $table->text('address')->nullable();
            $table->enum('pay_term_type', ['days', 'months'])->nullable();
            $table->integer('pay_term_value')->nullable();
            $table->decimal('credit_limit', 22, 4)->nullable();
            $table->timestamps();
        });
    }

    /**
     * Reverse the migrations.
     */
    public function down(): void
    {
        Schema::dropIfExists('contacts');
    }
};
