<?php

use Illuminate\Database\Migrations\Migration;
use Illuminate\Database\Schema\Blueprint;
use Illuminate\Support\Facades\Schema;

return new class extends Migration
{
    /**
     * Run the migrations.
     */
    public function up(): void
    {
        Schema::table('settings', function (Blueprint $table) {
            $table->string('number')->nullable()->after('company_name');
            $table->string('address')->nullable()->after('number');
            $table->string('company_registration_number')->nullable()->after('address');
            $table->string('company_email')->nullable()->after('company_registration_number');
            $table->string('website')->nullable()->after('company_email');
        });
    }

    /**
     * Reverse the migrations.
     */
    public function down(): void
    {
        Schema::table('settings', function (Blueprint $table) {
            $table->dropColumn(['number', 'address', 'company_registration_number', 'company_email', 'website']);
        });
    }
};
