<?php

namespace Database\Seeders;

use Illuminate\Database\Seeder;
use App\Models\Brand;
use App\Models\MobileModel;

class PhoneBrandsAndModelsSeeder extends Seeder
{
    public function run()
    {
        // Samsung
        $samsung = Brand::firstOrCreate(['tenant_id' => 1, 'name' => 'Samsung']);
        $this->createSamsungModels($samsung->id);

        // Apple
        $apple = Brand::firstOrCreate(['tenant_id' => 1, 'name' => 'Apple']);
        $this->createAppleModels($apple->id);

        // Xiaomi
        $xiaomi = Brand::firstOrCreate(['tenant_id' => 1, 'name' => 'Xiaomi']);
        $this->createXiaomiModels($xiaomi->id);

        // Huawei
        $huawei = Brand::firstOrCreate(['tenant_id' => 1, 'name' => 'Huawei']);
        $this->createHuaweiModels($huawei->id);

        // Oppo
        $oppo = Brand::firstOrCreate(['tenant_id' => 1, 'name' => 'Oppo']);
        $this->createOppoModels($oppo->id);

        // Vivo
        $vivo = Brand::firstOrCreate(['tenant_id' => 1, 'name' => 'Vivo']);
        $this->createVivoModels($vivo->id);

        // OnePlus
        $oneplus = Brand::firstOrCreate(['tenant_id' => 1, 'name' => 'OnePlus']);
        $this->createOnePlusModels($oneplus->id);

        // Google
        $google = Brand::firstOrCreate(['tenant_id' => 1, 'name' => 'Google']);
        $this->createGoogleModels($google->id);

        // Realme
        $realme = Brand::firstOrCreate(['tenant_id' => 1, 'name' => 'Realme']);
        $this->createRealmeModels($realme->id);

        // Honor
        $honor = Brand::firstOrCreate(['tenant_id' => 1, 'name' => 'Honor']);
        $this->createHonorModels($honor->id);

        // Tecno
        $tecno = Brand::firstOrCreate(['tenant_id' => 1, 'name' => 'Tecno']);
        $this->createTecnoModels($tecno->id);

        // Infinix
        $infinix = Brand::firstOrCreate(['tenant_id' => 1, 'name' => 'Infinix']);
        $this->createInfinixModels($infinix->id);

        // Itel
        $itel = Brand::firstOrCreate(['tenant_id' => 1, 'name' => 'Itel']);
        $this->createItelModels($itel->id);

        // Nokia
        $nokia = Brand::firstOrCreate(['tenant_id' => 1, 'name' => 'Nokia']);
        $this->createNokiaModels($nokia->id);

        // Motorola
        $motorola = Brand::firstOrCreate(['tenant_id' => 1, 'name' => 'Motorola']);
        $this->createMotorolaModels($motorola->id);

        // Sony
        $sony = Brand::firstOrCreate(['tenant_id' => 1, 'name' => 'Sony']);
        $this->createSonyModels($sony->id);

        echo "All phone brands and models have been added successfully!\n";
    }

    private function createSamsungModels($brandId)
    {
        $models = [
            // Galaxy S Series
            'Galaxy S24 Ultra', 'Galaxy S24+', 'Galaxy S24',
            'Galaxy S23 Ultra', 'Galaxy S23+', 'Galaxy S23',
            'Galaxy S22 Ultra', 'Galaxy S22+', 'Galaxy S22',
            'Galaxy S21 Ultra', 'Galaxy S21+', 'Galaxy S21',
            
            // Galaxy Note Series
            'Galaxy Note 20 Ultra', 'Galaxy Note 20',
            
            // Galaxy A Series
            'Galaxy A55', 'Galaxy A54', 'Galaxy A35', 'Galaxy A34',
            'Galaxy A25', 'Galaxy A24', 'Galaxy A15', 'Galaxy A14',
            'Galaxy A13', 'Galaxy A12', 'Galaxy A05s', 'Galaxy A05',
            
            // Galaxy Z Series (Foldables)
            'Galaxy Z Fold 5', 'Galaxy Z Flip 5',
            'Galaxy Z Fold 4', 'Galaxy Z Flip 4',
            'Galaxy Z Fold 3', 'Galaxy Z Flip 3',
            
            // Galaxy M Series
            'Galaxy M54', 'Galaxy M34', 'Galaxy M14', 'Galaxy M04'
        ];

        foreach ($models as $model) {
            MobileModel::firstOrCreate([
                'tenant_id' => 1,
                'brand_id' => $brandId,
                'name' => $model
            ]);
        }
    }

    private function createAppleModels($brandId)
    {
        $models = [
            // iPhone 15 Series
            'iPhone 15 Pro Max', 'iPhone 15 Pro', 'iPhone 15 Plus', 'iPhone 15',
            
            // iPhone 14 Series
            'iPhone 14 Pro Max', 'iPhone 14 Pro', 'iPhone 14 Plus', 'iPhone 14',
            
            // iPhone 13 Series
            'iPhone 13 Pro Max', 'iPhone 13 Pro', 'iPhone 13 mini', 'iPhone 13',
            
            // iPhone 12 Series
            'iPhone 12 Pro Max', 'iPhone 12 Pro', 'iPhone 12 mini', 'iPhone 12',
            
            // iPhone SE and older models
            'iPhone SE (3rd gen)', 'iPhone SE (2nd gen)',
            'iPhone 11 Pro Max', 'iPhone 11 Pro', 'iPhone 11',
            'iPhone XS Max', 'iPhone XS', 'iPhone XR'
        ];

        foreach ($models as $model) {
            MobileModel::firstOrCreate([
                'tenant_id' => 1,
                'brand_id' => $brandId,
                'name' => $model
            ]);
        }
    }

    private function createXiaomiModels($brandId)
    {
        $models = [
            // Xiaomi 14 Series
            'Xiaomi 14 Ultra', 'Xiaomi 14', 'Xiaomi 14T Pro', 'Xiaomi 14T',
            
            // Xiaomi 13 Series
            'Xiaomi 13 Ultra', 'Xiaomi 13 Pro', 'Xiaomi 13',
            'Xiaomi 13T Pro', 'Xiaomi 13T',
            
            // Redmi Note Series
            'Redmi Note 13 Pro+', 'Redmi Note 13 Pro', 'Redmi Note 13',
            'Redmi Note 12 Pro+', 'Redmi Note 12 Pro', 'Redmi Note 12',
            
            // Redmi Series
            'Redmi 13C', 'Redmi 12', 'Redmi A3', 'Redmi A2',
            
            // POCO Series
            'POCO X6 Pro', 'POCO X6', 'POCO M6 Pro', 'POCO M6',
            'POCO F5 Pro', 'POCO F5', 'POCO C65'
        ];

        foreach ($models as $model) {
            MobileModel::firstOrCreate([
                'tenant_id' => 1,
                'brand_id' => $brandId,
                'name' => $model
            ]);
        }
    }

    private function createHuaweiModels($brandId)
    {
        $models = [
            // P Series
            'P60 Pro', 'P60', 'P50 Pro', 'P50',
            
            // Mate Series
            'Mate 60 Pro+', 'Mate 60 Pro', 'Mate 60',
            'Mate 50 Pro', 'Mate 50',
            
            // Nova Series
            'Nova 12i', 'Nova 11i', 'Nova Y91', 'Nova Y71',
            
            // Y Series
            'Y9a', 'Y7a', 'Y6p', 'Y5p'
        ];

        foreach ($models as $model) {
            MobileModel::firstOrCreate([
                'tenant_id' => 1,
                'brand_id' => $brandId,
                'name' => $model
            ]);
        }
    }

    private function createOppoModels($brandId)
    {
        $models = [
            // Find X Series
            'Find X7 Ultra', 'Find X7', 'Find X6 Pro', 'Find X6',
            
            // Reno Series
            'Reno 12 Pro', 'Reno 12', 'Reno 11 Pro', 'Reno 11',
            'Reno 10 Pro+', 'Reno 10 Pro', 'Reno 10',
            
            // A Series
            'A98', 'A78', 'A58', 'A38', 'A18', 'A17k'
        ];

        foreach ($models as $model) {
            MobileModel::firstOrCreate([
                'tenant_id' => 1,
                'brand_id' => $brandId,
                'name' => $model
            ]);
        }
    }

    private function createVivoModels($brandId)
    {
        $models = [
            // X Series
            'X100 Pro', 'X100', 'X90 Pro', 'X90',
            
            // V Series
            'V30 Pro', 'V30', 'V29 Pro', 'V29',
            
            // Y Series
            'Y100', 'Y78', 'Y56', 'Y36', 'Y28', 'Y17s', 'Y03'
        ];

        foreach ($models as $model) {
            MobileModel::firstOrCreate([
                'tenant_id' => 1,
                'brand_id' => $brandId,
                'name' => $model
            ]);
        }
    }

    private function createOnePlusModels($brandId)
    {
        $models = [
            // OnePlus 12 Series
            'OnePlus 12', 'OnePlus 12R',
            
            // OnePlus 11 Series
            'OnePlus 11', 'OnePlus 11R',
            
            // OnePlus 10 Series
            'OnePlus 10 Pro', 'OnePlus 10R', 'OnePlus 10T',
            
            // Nord Series
            'OnePlus Nord CE 3 Lite', 'OnePlus Nord CE 3',
            'OnePlus Nord CE 2 Lite', 'OnePlus Nord CE 2',
            'OnePlus Nord 3', 'OnePlus Nord 2T'
        ];

        foreach ($models as $model) {
            MobileModel::firstOrCreate([
                'tenant_id' => 1,
                'brand_id' => $brandId,
                'name' => $model
            ]);
        }
    }

    private function createGoogleModels($brandId)
    {
        $models = [
            // Pixel 8 Series
            'Pixel 8 Pro', 'Pixel 8', 'Pixel 8a',
            
            // Pixel 7 Series
            'Pixel 7 Pro', 'Pixel 7', 'Pixel 7a',
            
            // Pixel 6 Series
            'Pixel 6 Pro', 'Pixel 6', 'Pixel 6a'
        ];

        foreach ($models as $model) {
            MobileModel::firstOrCreate([
                'tenant_id' => 1,
                'brand_id' => $brandId,
                'name' => $model
            ]);
        }
    }

    private function createRealmeModels($brandId)
    {
        $models = [
            // GT Series
            'Realme GT 5 Pro', 'Realme GT 5', 'Realme GT Neo 6',
            
            // Number Series
            'Realme 12 Pro+', 'Realme 12 Pro', 'Realme 12',
            'Realme 11 Pro+', 'Realme 11 Pro', 'Realme 11',
            
            // C Series
            'Realme C67', 'Realme C65', 'Realme C55', 'Realme C53',
            'Realme C35', 'Realme C33', 'Realme C30s'
        ];

        foreach ($models as $model) {
            MobileModel::firstOrCreate([
                'tenant_id' => 1,
                'brand_id' => $brandId,
                'name' => $model
            ]);
        }
    }

    private function createHonorModels($brandId)
    {
        $models = [
            // Magic Series
            'Honor Magic 6 Pro', 'Honor Magic 6', 'Honor Magic 5 Pro',
            
            // X Series
            'Honor X9b', 'Honor X8b', 'Honor X7b', 'Honor X6b',
            
            // Play Series
            'Honor Play 8T', 'Honor Play 7T'
        ];

        foreach ($models as $model) {
            MobileModel::firstOrCreate([
                'tenant_id' => 1,
                'brand_id' => $brandId,
                'name' => $model
            ]);
        }
    }

    private function createTecnoModels($brandId)
    {
        $models = [
            // Phantom Series
            'Tecno Phantom V Fold', 'Tecno Phantom V Flip',
            
            // Camon Series
            'Tecno Camon 30 Pro', 'Tecno Camon 30', 'Tecno Camon 20 Pro',
            
            // Pova Series
            'Tecno Pova 6 Pro', 'Tecno Pova 6', 'Tecno Pova 5 Pro',
            
            // Spark Series
            'Tecno Spark 20 Pro+', 'Tecno Spark 20 Pro', 'Tecno Spark 20',
            'Tecno Spark 10 Pro', 'Tecno Spark 10', 'Tecno Spark Go'
        ];

        foreach ($models as $model) {
            MobileModel::firstOrCreate([
                'tenant_id' => 1,
                'brand_id' => $brandId,
                'name' => $model
            ]);
        }
    }

    private function createInfinixModels($brandId)
    {
        $models = [
            // Zero Series
            'Infinix Zero 40', 'Infinix Zero 30',
            
            // Note Series
            'Infinix Note 40 Pro+', 'Infinix Note 40 Pro', 'Infinix Note 40',
            'Infinix Note 30 Pro', 'Infinix Note 30',
            
            // Hot Series
            'Infinix Hot 50 Pro+', 'Infinix Hot 50 Pro', 'Infinix Hot 50',
            'Infinix Hot 40 Pro', 'Infinix Hot 40i', 'Infinix Hot 30i',
            
            // Smart Series
            'Infinix Smart 8 Pro', 'Infinix Smart 8', 'Infinix Smart 7'
        ];

        foreach ($models as $model) {
            MobileModel::firstOrCreate([
                'tenant_id' => 1,
                'brand_id' => $brandId,
                'name' => $model
            ]);
        }
    }

    private function createItelModels($brandId)
    {
        $models = [
            // A Series
            'Itel A70', 'Itel A58 Pro', 'Itel A56 Pro', 'Itel A48',
            
            // S Series
            'Itel S17', 'Itel S16', 'Itel S15'
        ];

        foreach ($models as $model) {
            MobileModel::firstOrCreate([
                'tenant_id' => 1,
                'brand_id' => $brandId,
                'name' => $model
            ]);
        }
    }

    private function createNokiaModels($brandId)
    {
        $models = [
            // G Series
            'Nokia G60 5G', 'Nokia G50', 'Nokia G21', 'Nokia G11',
            
            // X Series
            'Nokia X30 5G', 'Nokia X20', 'Nokia X10',
            
            // C Series
            'Nokia C32', 'Nokia C22', 'Nokia C12', 'Nokia C02'
        ];

        foreach ($models as $model) {
            MobileModel::firstOrCreate([
                'tenant_id' => 1,
                'brand_id' => $brandId,
                'name' => $model
            ]);
        }
    }

    private function createMotorolaModels($brandId)
    {
        $models = [
            // Edge Series
            'Motorola Edge 50 Ultra', 'Motorola Edge 50 Pro', 'Motorola Edge 50',
            'Motorola Edge 40 Pro', 'Motorola Edge 40',
            
            // Moto G Series
            'Moto G84', 'Moto G73', 'Moto G53', 'Moto G32', 'Moto G23',
            'Moto G14', 'Moto G13', 'Moto G04s',
            
            // Moto E Series
            'Moto E13', 'Moto E22s'
        ];

        foreach ($models as $model) {
            MobileModel::firstOrCreate([
                'tenant_id' => 1,
                'brand_id' => $brandId,
                'name' => $model
            ]);
        }
    }

    private function createSonyModels($brandId)
    {
        $models = [
            // Xperia 1 Series
            'Xperia 1 VI', 'Xperia 1 V', 'Xperia 1 IV',
            
            // Xperia 5 Series
            'Xperia 5 V', 'Xperia 5 IV',
            
            // Xperia 10 Series
            'Xperia 10 VI', 'Xperia 10 V', 'Xperia 10 IV'
        ];

        foreach ($models as $model) {
            MobileModel::firstOrCreate([
                'tenant_id' => 1,
                'brand_id' => $brandId,
                'name' => $model
            ]);
        }
    }
}