@extends('layouts.app')

@section('main')
<div class="container-fluid">
    <div class="row">
        <div class="col-12">
            <div class="card">
                <div class="card-header">
                    <h3 class="card-title">Plan Details</h3>
                    <a href="{{ route('plans.index') }}" class="btn btn-secondary float-right">Back</a>
                </div>
                <div class="card-body">
                    <table class="table table-bordered">
                        <tr>
                            <th>ID</th>
                            <td>{{ $plan->id }}</td>
                        </tr>
                        <tr>
                            <th>Name</th>
                            <td>{{ $plan->name }}</td>
                        </tr>
                        <tr>
                            <th>Description</th>
                            <td>{{ $plan->description }}</td>
                        </tr>
                        <tr>
                            <th>Price</th>
                            <td>${{ $plan->price }}</td>
                        </tr>
                        <tr>
                            <th>Interval</th>
                            <td>{{ $plan->interval }}</td>
                        </tr>
                        <tr>
                            <th>Max Users</th>
                            <td>{{ $plan->max_users }}</td>
                        </tr>
                        <tr>
                            <th>Max Products</th>
                            <td>{{ $plan->max_products }}</td>
                        </tr>
                        <tr>
                            <th>Features</th>
                            <td>{{ $plan->features }}</td>
                        </tr>
                        <tr>
                            <th>Active</th>
                            <td>{{ $plan->is_active ? 'Yes' : 'No' }}</td>
                        </tr>
                        <tr>
                            <th>Created At</th>
                            <td>{{ $plan->created_at }}</td>
                        </tr>
                        <tr>
                            <th>Updated At</th>
                            <td>{{ $plan->updated_at }}</td>
                        </tr>
                    </table>
                </div>
            </div>
        </div>
    </div>
</div>
@endsection
