@extends('layouts.app')

@section('content')
<div class="container mt-5">
    <div class="row justify-content-center">
        <div class="col-md-8">
            <div class="card">
                <div class="card-header 
                    @if($existingSubscription->status == 'pending') bg-warning text-white
                    @elseif($existingSubscription->status == 'cancelled') bg-danger text-white
                    @elseif($existingSubscription->status == 'expired') bg-secondary text-white
                    @else bg-info text-white
                    @endif
                ">
                    <h4 class="mb-0">
                        <i class="fas 
                            @if($existingSubscription->status == 'pending') fa-clock
                            @elseif($existingSubscription->status == 'cancelled') fa-times-circle
                            @elseif($existingSubscription->status == 'expired') fa-calendar-times
                            @else fa-info-circle
                            @endif
                        "></i> 
                        @if($existingSubscription->status == 'pending') Subscription Pending Approval
                        @elseif($existingSubscription->status == 'cancelled') Subscription Cancelled
                        @elseif($existingSubscription->status == 'expired') Subscription Expired
                        @else Subscription Status: {{ ucfirst($existingSubscription->status) }}
                        @endif
                    </h4>
                </div>
                <div class="card-body text-center">
                    <div class="mb-4">
                        <i class="fas 
                            @if($existingSubscription->status == 'pending') fa-hourglass-half fa-4x text-warning
                            @elseif($existingSubscription->status == 'cancelled') fa-times-circle fa-4x text-danger
                            @elseif($existingSubscription->status == 'expired') fa-calendar-times fa-4x text-secondary
                            @else fa-info-circle fa-4x text-info
                            @endif
                        "></i>
                    </div>
                    <h5 class="card-title">
                        @if($existingSubscription->status == 'pending') Your subscription request is still under review
                        @elseif($existingSubscription->status == 'cancelled') Your subscription has been cancelled
                        @elseif($existingSubscription->status == 'expired') Your subscription has expired
                        @else Your subscription status is: {{ ucfirst($existingSubscription->status) }}
                        @endif
                    </h5>
                    <p class="card-text">
                        @if($existingSubscription->status == 'pending')
                            You have already submitted a subscription request that is currently pending approval from the super admin.
                            Please wait for the admin to review and approve your subscription before creating a new one.
                        @elseif($existingSubscription->status == 'cancelled')
                            Your previous subscription has been cancelled. You can create a new subscription request if needed.
                        @elseif($existingSubscription->status == 'expired')
                            Your previous subscription has expired. You can create a new subscription request if needed.
                        @else
                            Your current subscription status does not allow creating a new subscription at this time.
                        @endif
                    </p>
                    @if($existingSubscription->status != 'pending')
                        <p class="text-muted">You can create a new subscription request below.</p>
                        <a href="{{ route('subscriptions.create') }}" class="btn btn-primary">
                            <i class="fas fa-plus"></i> Create New Subscription
                        </a>
                    @else
                        <p class="text-muted">
                            If you have any questions, please contact the administrator.
                        </p>
                    @endif
                    <br><br>
                    <a href="{{ route('dashboard') }}" class="btn btn-secondary">
                        <i class="fas fa-home"></i> Go to Dashboard
                    </a>
                </div>
            </div>
        </div>
    </div>
</div>
@endsection
