@extends('layouts.app')

@section('main')
<div class="container-fluid">
    <div class="row">
        <div class="col-12">
            <div class="card">
                <div class="card-header">
                    <h3 class="card-title">Edit Tenant</h3>
                </div>
                <div class="card-body">
                    <form action="{{ route('tenants.update', $tenant) }}" method="POST">
                        @csrf
                        @method('PUT')
                        <div class="form-group">
                            <label for="name">Tenant Name</label>
                            <input type="text" class="form-control" id="name" name="name" value="{{ old('name', $tenant->name) }}" required>
                        </div>
                        <div class="form-group">
                            <label for="domain">Domain</label>
                            <input type="text" class="form-control" id="domain" name="domain" value="{{ old('domain', $tenant->domain) }}" required>
                        </div>
                        <div class="form-group">
                            <label for="subdomain">Subdomain (Optional)</label>
                            <input type="text" class="form-control" id="subdomain" name="subdomain" value="{{ old('subdomain', $tenant->subdomain) }}">
                        </div>
                        <button type="submit" class="btn btn-primary">Update Tenant</button>
                    </form>
                </div>
            </div>
        </div>
    </div>
</div>
@endsection
