@extends('layouts.app')

@section('main')
<div class="container-fluid">
    <div class="row">
        <div class="col-12">
            <div class="card">
                <div class="card-header">
                    <h3 class="card-title">Tenants</h3>
                    <a href="{{ route('tenants.create') }}" class="btn btn-primary float-right">Create Tenant</a>
                </div>
                <div class="card-body">
                    @if(session('success'))
                        <div class="alert alert-success">{{ session('success') }}</div>
                    @endif
                    <table class="table table-bordered">
                        <thead>
                            <tr>
                                <th>ID</th>
                                <th>Name</th>
                                <th>Domain</th>
                                <th>Subdomain</th>
                                <th>Users</th>
                                <th>Actions</th>
                            </tr>
                        </thead>
                        <tbody>
                            @foreach($tenants as $tenant)
                            <tr>
                                <td>{{ $tenant->id }}</td>
                                <td>{{ $tenant->name }}</td>
                                <td>{{ $tenant->domain }}</td>
                                <td>{{ $tenant->subdomain }}</td>
                                <td>{{ $tenant->users->count() }}</td>
                                <td>
                                    <a href="{{ route('tenants.show', $tenant) }}" class="btn btn-info btn-sm">View</a>
                                    <a href="{{ route('tenants.edit', $tenant) }}" class="btn btn-warning btn-sm">Edit</a>
                                    <form action="{{ route('tenants.destroy', $tenant) }}" method="POST" style="display:inline;">
                                        @csrf
                                        @method('DELETE')
                                        <button type="submit" class="btn btn-danger btn-sm" onclick="return confirm('Are you sure?')">Delete</button>
                                    </form>
                                </td>
                            </tr>
                            @endforeach
                        </tbody>
                    </table>
                </div>
            </div>
        </div>
    </div>
</div>
@endsection
