<!-- WhatsApp Send Button Component -->
<button type="button" class="btn btn-success btn-sm whatsapp-send-btn" 
        data-phone="{{ $phone ?? '' }}" 
        data-customer="{{ $customerName ?? '' }}" 
        data-invoice="{{ $invoiceNumber ?? '' }}" 
        data-total="{{ $total ?? 0 }}" 
        data-items="{{ $items ?? '' }}"
        onclick="sendWhatsAppInvoice(this)">
    <i class="fab fa-whatsapp mr-1"></i>Send WhatsApp
</button>

<script>
function sendWhatsAppInvoice(button) {
    const phone = $(button).data('phone');
    const customer = $(button).data('customer');
    const invoice = $(button).data('invoice');
    const total = $(button).data('total');
    const items = $(button).data('items');
    
    if (!phone || !customer || !invoice) {
        toastr.error('Missing required information for WhatsApp message');
        return;
    }
    
    // Show loading state
    const originalHtml = $(button).html();
    $(button).html('<i class="fas fa-spinner fa-spin mr-1"></i>Sending...').prop('disabled', true);
    
    // Send WhatsApp message
    $.ajax({
        url: '{{ route("whatsapp.send.invoice") }}',
        method: 'POST',
        data: {
            _token: '{{ csrf_token() }}',
            phone: phone,
            customer_name: customer,
            invoice_number: invoice,
            total_amount: total,
            items: items
        },
        success: function(response) {
            if (response.success) {
                toastr.success(response.message);
                
                // Show message preview modal
                if (response.preview_message) {
                    showMessagePreview(response.preview_message, response.phone);
                }
            } else {
                if (response.redirect_url) {
                    toastr.error(response.message + ' Redirecting to connection page...');
                    setTimeout(() => {
                        window.open(response.redirect_url, '_blank');
                    }, 2000);
                } else {
                    toastr.error(response.message);
                }
            }
        },
        error: function(xhr) {
            const response = xhr.responseJSON;
            toastr.error(response?.message || 'Failed to send WhatsApp message');
        },
        complete: function() {
            // Restore button state
            $(button).html(originalHtml).prop('disabled', false);
        }
    });
}

function showMessagePreview(message, phone) {
    const modal = `
        <div class="modal fade" id="whatsappPreviewModal" tabindex="-1">
            <div class="modal-dialog modal-dialog-centered">
                <div class="modal-content">
                    <div class="modal-header bg-success text-white">
                        <h5 class="modal-title">
                            <i class="fab fa-whatsapp mr-2"></i>Message Sent Successfully
                        </h5>
                        <button type="button" class="close text-white" data-dismiss="modal">
                            <span>&times;</span>
                        </button>
                    </div>
                    <div class="modal-body">
                        <div class="alert alert-success">
                            <i class="fas fa-check-circle mr-2"></i>
                            WhatsApp message sent to <strong>${phone}</strong>
                        </div>
                        
                        <h6>Message Preview:</h6>
                        <div class="whatsapp-message-preview">
                            ${message.replace(/\n/g, '<br>')}
                        </div>
                    </div>
                    <div class="modal-footer">
                        <button type="button" class="btn btn-secondary" data-dismiss="modal">Close</button>
                    </div>
                </div>
            </div>
        </div>
    `;
    
    // Remove existing modal and show new one
    $('#whatsappPreviewModal').remove();
    $('body').append(modal);
    $('#whatsappPreviewModal').modal('show');
}
</script>

<style>
.whatsapp-message-preview {
    background: #dcf8c6;
    padding: 15px;
    border-radius: 8px;
    font-family: 'Segoe UI', sans-serif;
    white-space: pre-line;
    border: 1px solid #c3e6cb;
    max-height: 300px;
    overflow-y: auto;
}
</style>