@extends('layouts.app')

@section('main')
<div class="container-fluid p-4">
    <div class="row">
        <div class="col-12">
            <div class="card">
                <div class="card-header">
                    <h4>Customer Credits</h4>
                    @php
                        $totalCredit = $customers->sum('total_due');
                    @endphp
                    <div class="float-end">
                        <strong>Total Outstanding Credit: BHD {{ number_format($totalCredit, 2) }}</strong>
                    </div>
                </div>
                <div class="card-body">
                    <div class="table-responsive">
                        <table class="table table-striped">
                            <thead>
                                <tr>
                                    <th>ID</th>
                                    <th>Name</th>
                                    <th>Phone</th>
                                    <th>CPR</th>
                                    <th>Address</th>
                                    <th>Total Due (BHD)</th>
                                    <th>Actions</th>
                                </tr>
                            </thead>
                            <tbody>
                                @foreach($customers as $customer)
                                <tr>
                                    <td>{{ $customer->id }}</td>
                                    <td>{{ $customer->name }}</td>
                                    <td>{{ $customer->number }}</td>
                                    <td>{{ $customer->cpr }}</td>
                                    <td>{{ $customer->address }}</td>
                                    <td>{{ number_format($customer->total_due, 2) }}</td>
                                    <td>
                                        <button class="btn btn-sm btn-secondary" type="button" data-bs-toggle="collapse" data-bs-target="#details-{{ $customer->id }}" aria-expanded="false" aria-controls="details-{{ $customer->id }}">
                                            Show Dependencies
                                        </button>
                                        <a href="{{ route('customer.show', $customer->id) }}" class="btn btn-sm btn-info">View Details</a>
                                    </td>
                                </tr>
                                <tr>
                                    <td colspan="7" class="p-0">
                                        <div class="collapse" id="details-{{ $customer->id }}">
                                            <div class="card card-body m-2">
                                                <h6>Dependencies for {{ $customer->name }}</h6>
                                                @if($customer->sales->count() > 0)
                                                <table class="table table-sm table-bordered">
                                                    <thead>
                                                        <tr>
                                                            <th>Date</th>
                                                            <th>Total Amount (BHD)</th>
                                                            <th>Due Amount (BHD)</th>
                                                            <th>Status</th>
                                                            <th>Type</th>
                                                        </tr>
                                                    </thead>
                                                    <tbody>
                                                        @foreach($customer->sales as $sale)
                                                        <tr>
                                                            <td>{{ $sale->created_at->format('Y-m-d H:i') }}</td>
                                                            <td>{{ number_format($sale->total_amount, 2) }}</td>
                                                            <td>
                                                                @php
                                                                    $dueAmount = $sale->due_amount;
                                                                    $duePayments = \App\Models\CustomerPayment::where('customer_id', $customer->id)
                                                                        ->where('type', 'due_payment')
                                                                        ->whereJsonContains('sale_ids', $sale->id)
                                                                        ->sum('amount');
                                                                    $netDue = $dueAmount - $duePayments;
                                                                @endphp
                                                                {{ number_format(max(0, $netDue), 2) }}
                                                            </td>
                                                            <td>{{ ucfirst($sale->payment_status) }}</td>
                                                            <td>
                                                                @if($netDue < 0)
                                                                    <span class="badge bg-success">Advance Payment</span>
                                                                @elseif($sale->payment_status == 'unpaid')
                                                                    <span class="badge bg-danger">Unpaid</span>
                                                                @elseif($sale->payment_status == 'partial')
                                                                    <span class="badge bg-warning">Partial Payment</span>
                                                                @else
                                                                    <span class="badge bg-info">{{ ucfirst($sale->payment_status) }}</span>
                                                                @endif
                                                            </td>
                                                        </tr>
                                                        @endforeach
                                                    </tbody>
                                                </table>
                                                @else
                                                <p>No dependencies found.</p>
                                                @endif
                                            </div>
                                        </div>
                                    </td>
                                </tr>
                                @endforeach
                            </tbody>
                        </table>
                    </div>
                </div>
            </div>
        </div>
    </div>
</div>
@endsection
