@extends('adminlte::page')

@section('title', 'Sales Report')

@section('content_header')
    <h1>Sales Report</h1>
@stop

@section('content')
    <div class="row">
        <div class="col-md-4">
            <div class="info-box">
                <span class="info-box-icon bg-aqua"><i class="fas fa-dollar-sign"></i></span>
                <div class="info-box-content">
                    <span class="info-box-text">Total Direct Sales Profit</span>
                    <span class="info-box-number">${{ number_format($directSalesProfit, 2) }}</span>
                </div>
            </div>
        </div>
        <div class="col-md-4">
            <div class="info-box">
                <span class="info-box-icon bg-green"><i class="fas fa-dollar-sign"></i></span>
                <div class="info-box-content">
                    <span class="info-box-text">Total Sell Transactions Profit</span>
                    <span class="info-box-number">${{ number_format($sellTransactionsProfit, 2) }}</span>
                </div>
            </div>
        </div>
        <div class="col-md-4">
            <div class="info-box">
                <span class="info-box-icon bg-yellow"><i class="fas fa-dollar-sign"></i></span>
                <div class="info-box-content">
                    <span class="info-box-text">Net Profit</span>
                    <span class="info-box-number">${{ number_format($netProfit, 2) }}</span>
                </div>
            </div>
        </div>
    </div>

    <div class="card">
        <div class="card-header">
            <h3 class="card-title">Direct Sales</h3>
        </div>
        <div class="card-body">
            <table class="table table-bordered table-striped">
                <thead>
                    <tr>
                        <th>Sell Price</th>
                        <th>Profit</th>
                        <th>Date Time</th>
                    </tr>
                </thead>
                <tbody>
                    @foreach($directSales as $sale)
                        <tr>
                            <td>${{ number_format($sale->direct_sell_price, 2) }}</td>
                            <td>${{ number_format($sale->direct_profit, 2) }}</td>
                            <td>{{ $sale->direct_date_time }}</td>
                        </tr>
                    @endforeach
                </tbody>
            </table>
        </div>
    </div>

    <div class="card">
        <div class="card-header">
            <h3 class="card-title">Sell Transactions</h3>
        </div>
        <div class="card-body">
            <table class="table table-bordered table-striped">
                <thead>
                    <tr>
                        <th>Sell Price</th>
                        <th>Profit</th>
                        <th>Date Time</th>
                    </tr>
                </thead>
                <tbody>
                    @foreach($sellTransactions as $transaction)
                        <tr>
                            <td>${{ number_format($transaction->sell_price, 2) }}</td>
                            <td>${{ number_format($transaction->profit, 2) }}</td>
                            <td>{{ $transaction->date_time }}</td>
                        </tr>
                    @endforeach
                </tbody>
            </table>
        </div>
    </div>
@stop

@section('css')
    <link rel="stylesheet" href="/css/admin_custom.css">
@stop

@section('js')
    <script> console.log('Hi!'); </script>
@stop