@extends('layouts.app')

@section('title', 'Invoice Settings')

@push('style')
<style>
    .settings-card {
        border-radius: 15px;
        box-shadow: 0 4px 15px rgba(0,0,0,0.1);
        border: none;
    }
    .settings-header {
        background: linear-gradient(135deg, #667eea 0%, #764ba2 100%);
        color: white;
        border-radius: 15px 15px 0 0;
        padding: 20px;
    }
    .form-group label {
        font-weight: 600;
        color: #495057;
        margin-bottom: 8px;
    }
    .template-preview {
        background: #f8f9fa;
        border: 2px dashed #dee2e6;
        border-radius: 8px;
        padding: 20px;
        text-align: center;
        transition: all 0.3s ease;
    }
    .template-preview:hover {
        border-color: #007bff;
        background: #e7f3ff;
    }
    .whatsapp-preview {
        background: #25d366;
        color: white;
        border-radius: 20px;
        padding: 15px;
        font-family: 'Segoe UI', sans-serif;
        white-space: pre-line;
        max-height: 300px;
        overflow-y: auto;
    }
    .toggle-switch {
        position: relative;
        display: inline-block;
        width: 60px;
        height: 34px;
    }
    .toggle-switch input {
        opacity: 0;
        width: 0;
        height: 0;
    }
    .slider {
        position: absolute;
        cursor: pointer;
        top: 0;
        left: 0;
        right: 0;
        bottom: 0;
        background-color: #ccc;
        transition: .4s;
        border-radius: 34px;
    }
    .slider:before {
        position: absolute;
        content: "";
        height: 26px;
        width: 26px;
        left: 4px;
        bottom: 4px;
        background-color: white;
        transition: .4s;
        border-radius: 50%;
    }
    input:checked + .slider {
        background-color: #28a745;
    }
    input:checked + .slider:before {
        transform: translateX(26px);
    }
    .variable-tag {
        background: #e9ecef;
        border: 1px solid #ced4da;
        border-radius: 4px;
        padding: 2px 8px;
        margin: 2px;
        display: inline-block;
        font-size: 12px;
        color: #495057;
        cursor: pointer;
    }
    .variable-tag:hover {
        background: #007bff;
        color: white;
    }
</style>
@endpush

@section('main')
<div class="content-header">
    <div class="container-fluid">
        <div class="row mb-2">
            <div class="col-sm-6">
                <h1 class="m-0">Invoice Settings</h1>
            </div>
            <div class="col-sm-6">
                <ol class="breadcrumb float-sm-right">
                    <li class="breadcrumb-item"><a href="{{ route('dashboard') }}">Home</a></li>
                    <li class="breadcrumb-item active">Invoice Settings</li>
                </ol>
            </div>
        </div>
    </div>
</div>

<section class="content">
    <div class="container-fluid">
        @if(session('success'))
            <div class="alert alert-success alert-dismissible fade show">
                <i class="fas fa-check-circle mr-2"></i>{{ session('success') }}
                <button type="button" class="close" data-dismiss="alert" aria-label="Close">
                    <span aria-hidden="true">&times;</span>
                </button>
            </div>
        @endif

        @if(session('error'))
            <div class="alert alert-danger alert-dismissible fade show">
                <i class="fas fa-exclamation-circle mr-2"></i>{{ session('error') }}
                <button type="button" class="close" data-dismiss="alert" aria-label="Close">
                    <span aria-hidden="true">&times;</span>
                </button>
            </div>
        @endif

            <form action="{{ route('invoice-settings.update') }}" method="POST" id="settingsForm">
            @csrf
            @method('PUT')
            
            <!-- Hidden fields for WhatsApp advanced settings -->
            <input type="hidden" name="whatsapp_welcome_message" value="{{ $settings->whatsapp_welcome_message ?? '' }}">
            <input type="hidden" name="whatsapp_payment_reminder_message" value="{{ $settings->whatsapp_payment_reminder_message ?? '' }}">
            <input type="hidden" name="whatsapp_delivery_message" value="{{ $settings->whatsapp_delivery_message ?? '' }}">
            <input type="hidden" name="whatsapp_thank_you_message" value="{{ $settings->whatsapp_thank_you_message ?? '' }}">
            <input type="hidden" name="whatsapp_include_business_hours" value="{{ $settings->whatsapp_include_business_hours ? '1' : '0' }}">
            <input type="hidden" name="whatsapp_business_hours" value="{{ $settings->whatsapp_business_hours ?? '' }}">
            
            <div class="row">
                <!-- Company & Basic Settings -->
                <div class="col-md-6">
                    <div class="card settings-card mb-4">
                        <div class="settings-header">
                            <h4 class="mb-0"><i class="fas fa-building mr-2"></i>Company Information</h4>
                        </div>
                        <div class="card-body">
                            <div class="form-group">
                                <label for="company_name">Company Name</label>
                                <input type="text" class="form-control" id="company_name" name="company_name" 
                                       value="{{ $settings->company_name ?? '' }}" required>
                            </div>

                            <div class="form-group">
                                <label for="invoice_header_text">Invoice Header Text</label>
                                <input type="text" class="form-control" id="invoice_header_text" name="invoice_header_text" 
                                       value="{{ $settings->invoice_header_text ?? 'INVOICE' }}" required>
                            </div>

                            <div class="form-group">
                                <label for="invoice_footer_text">Invoice Footer Text</label>
                                <textarea class="form-control" id="invoice_footer_text" name="invoice_footer_text" 
                                          rows="3">{{ $settings->invoice_footer_text ?? '' }}</textarea>
                            </div>

                            <div class="form-group">
                                <label for="invoice_template">Invoice Template</label>
                                <select class="form-control" id="invoice_template" name="invoice_template">
                                    <option value="default" {{ ($settings->invoice_template ?? 'default') == 'default' ? 'selected' : '' }}>Default</option>
                                    <option value="modern" {{ ($settings->invoice_template ?? '') == 'modern' ? 'selected' : '' }}>Modern</option>
                                    <option value="classic" {{ ($settings->invoice_template ?? '') == 'classic' ? 'selected' : '' }}>Classic</option>
                                    <option value="minimal" {{ ($settings->invoice_template ?? '') == 'minimal' ? 'selected' : '' }}>Minimal</option>
                                </select>
                            </div>
                        </div>
                    </div>

                    <!-- WhatsApp Settings -->
                    <div class="card settings-card mb-4">
                        <div class="settings-header">
                            <h4 class="mb-0">
                                <i class="fab fa-whatsapp mr-2"></i>WhatsApp Settings
                                <a href="{{ route('whatsapp.management') }}" class="btn btn-sm btn-light float-right">
                                    <i class="fas fa-cogs mr-1"></i>Advanced Management
                                </a>
                            </h4>
                        </div>
                        <div class="card-body">
                            <div class="form-group">
                                <label for="whatsapp_country_code">Default Country Code</label>
                                <select class="form-control" id="whatsapp_country_code" name="whatsapp_country_code">
                                    <option value="+880" {{ ($settings->whatsapp_country_code ?? '+880') == '+880' ? 'selected' : '' }}>🇧🇩 +880 (Bangladesh)</option>
                                    <option value="+91" {{ ($settings->whatsapp_country_code ?? '') == '+91' ? 'selected' : '' }}>🇮🇳 +91 (India)</option>
                                    <option value="+92" {{ ($settings->whatsapp_country_code ?? '') == '+92' ? 'selected' : '' }}>🇵🇰 +92 (Pakistan)</option>
                                    <option value="+1" {{ ($settings->whatsapp_country_code ?? '') == '+1' ? 'selected' : '' }}>🇺🇸 +1 (USA)</option>
                                    <option value="+44" {{ ($settings->whatsapp_country_code ?? '') == '+44' ? 'selected' : '' }}>🇬🇧 +44 (UK)</option>
                                    <option value="+971" {{ ($settings->whatsapp_country_code ?? '') == '+971' ? 'selected' : '' }}>🇦🇪 +971 (UAE)</option>
                                    <option value="+966" {{ ($settings->whatsapp_country_code ?? '') == '+966' ? 'selected' : '' }}>🇸🇦 +966 (Saudi Arabia)</option>
                                </select>
                                <small class="text-muted">Default country code for customer phone numbers</small>
                            </div>

                            <div class="form-group">
                                <div class="d-flex justify-content-between align-items-center">
                                    <label class="mb-0">Enable WhatsApp Integration</label>
                                    <label class="toggle-switch">
                                        <input type="checkbox" name="whatsapp_enabled" value="1" 
                                               {{ ($settings->whatsapp_enabled ?? true) ? 'checked' : '' }}>
                                        <span class="slider"></span>
                                    </label>
                                </div>
                                <small class="text-muted">Allow sending invoices via WhatsApp</small>
                            </div>

                            <div class="form-group">
                                <div class="d-flex justify-content-between align-items-center">
                                    <label class="mb-0">Auto-Send WhatsApp</label>
                                    <label class="toggle-switch">
                                        <input type="checkbox" name="auto_send_whatsapp" value="1" 
                                               {{ ($settings->auto_send_whatsapp ?? false) ? 'checked' : '' }}>
                                        <span class="slider"></span>
                                    </label>
                                </div>
                                <small class="text-muted">Automatically prompt to send WhatsApp after sale</small>
                            </div>

                            <div class="form-group">
                                <div class="d-flex justify-content-between align-items-center">
                                    <label class="mb-0">Auto-Format Phone Numbers</label>
                                    <label class="toggle-switch">
                                        <input type="checkbox" name="whatsapp_auto_format_numbers" value="1" 
                                               {{ ($settings->whatsapp_auto_format_numbers ?? true) ? 'checked' : '' }}>
                                        <span class="slider"></span>
                                    </label>
                                </div>
                                <small class="text-muted">Automatically add country code to local numbers</small>
                            </div>

                            <div class="alert alert-info">
                                <i class="fas fa-qrcode mr-2"></i>
                                <strong>QR Code System Active!</strong> Visit the 
                                <a href="{{ route('whatsapp.management') }}" class="alert-link">Advanced WhatsApp Management</a> 
                                page to configure QR code settings, message templates, and test QR functionality.
                            </div>

                            <!-- Quick QR Test -->
                            <div class="card bg-light">
                                <div class="card-body text-center">
                                    <h6><i class="fas fa-qrcode mr-2"></i>Quick Test</h6>
                                    <button type="button" class="btn btn-success btn-sm" onclick="testQuickQr()">
                                        <i class="fab fa-whatsapp mr-1"></i>Generate Test QR
                                    </button>
                                </div>
                            </div>
                        </div>
                    </div>

                    <!-- Additional Options -->
                    <div class="card settings-card">
                        <div class="settings-header">
                            <h4 class="mb-0"><i class="fas fa-cogs mr-2"></i>Additional Options</h4>
                        </div>
                        <div class="card-body">
                            <div class="form-group">
                                <div class="d-flex justify-content-between align-items-center">
                                    <label class="mb-0">Include Company Logo</label>
                                    <label class="toggle-switch">
                                        <input type="checkbox" name="include_company_logo" value="1" 
                                               {{ ($settings->include_company_logo ?? true) ? 'checked' : '' }}>
                                        <span class="slider"></span>
                                    </label>
                                </div>
                                <small class="text-muted">Show company logo on invoices</small>
                            </div>

                            <div class="form-group">
                                <div class="d-flex justify-content-between align-items-center">
                                    <label class="mb-0">Include QR Code</label>
                                    <label class="toggle-switch">
                                        <input type="checkbox" name="include_qr_code" value="1" 
                                               {{ ($settings->include_qr_code ?? false) ? 'checked' : '' }}>
                                        <span class="slider"></span>
                                    </label>
                                </div>
                                <small class="text-muted">Add QR code for digital verification</small>
                            </div>
                        </div>
                    </div>
                </div>

                <!-- WhatsApp Message Template -->
                <div class="col-md-6">
                    <div class="card settings-card mb-4">
                        <div class="settings-header">
                            <h4 class="mb-0"><i class="fas fa-comment-alt mr-2"></i>WhatsApp Message Template</h4>
                        </div>
                        <div class="card-body">
                            <div class="form-group">
                                <label for="invoice_message_template">Message Template</label>
                                <textarea class="form-control" id="invoice_message_template" name="invoice_message_template" 
                                          rows="12" required>{{ $settings->invoice_message_template ?? '' }}</textarea>
                                <small class="text-muted">Customize your WhatsApp invoice message</small>
                            </div>

                            <div class="mb-3">
                                <label class="font-weight-bold">Available Variables:</label>
                                <div class="mt-2">
                                    <span class="variable-tag" data-variable="{invoice_number}">Invoice Number</span>
                                    <span class="variable-tag" data-variable="{customer_name}">Customer Name</span>
                                    <span class="variable-tag" data-variable="{customer_phone}">Customer Phone</span>
                                    <span class="variable-tag" data-variable="{invoice_date}">Invoice Date</span>
                                    <span class="variable-tag" data-variable="{item_list}">Item List</span>
                                    <span class="variable-tag" data-variable="{currency}">Currency</span>
                                    <span class="variable-tag" data-variable="{total_amount}">Total Amount</span>
                                    <span class="variable-tag" data-variable="{payment_method}">Payment Method</span>
                                    <span class="variable-tag" data-variable="{payment_status}">Payment Status</span>
                                    <span class="variable-tag" data-variable="{invoice_link}">Invoice Link</span>
                                </div>
                            </div>

                            <div class="whatsapp-preview" id="whatsappPreview">
                                <!-- Preview will be updated via JavaScript -->
                            </div>
                        </div>
                    </div>

                    <!-- Terms & Conditions -->
                    <div class="card settings-card">
                        <div class="settings-header">
                            <h4 class="mb-0"><i class="fas fa-file-contract mr-2"></i>Terms & Conditions</h4>
                        </div>
                        <div class="card-body">
                            <div class="form-group">
                                <label for="invoice_terms_conditions">Terms & Conditions</label>
                                <textarea class="form-control" id="invoice_terms_conditions" name="invoice_terms_conditions" 
                                          rows="8">{{ $settings->invoice_terms_conditions ?? '' }}</textarea>
                                <small class="text-muted">These will appear at the bottom of invoices</small>
                            </div>
                        </div>
                    </div>
                </div>
            </div>

            <!-- Action Buttons -->
            <div class="row">
                <div class="col-12">
                    <div class="card">
                        <div class="card-body text-center">
                            <button type="submit" class="btn btn-success btn-lg mr-3">
                                <i class="fas fa-save mr-2"></i>Save Settings
                            </button>
                            <button type="button" class="btn btn-info btn-lg mr-3" onclick="previewTemplate()">
                                <i class="fas fa-eye mr-2"></i>Preview Invoice
                            </button>
                            <a href="{{ route('invoice-settings.reset-defaults') }}" class="btn btn-warning btn-lg mr-3" 
                               onclick="return confirm('Are you sure you want to reset to default settings?')">
                                <i class="fas fa-undo mr-2"></i>Reset to Defaults
                            </a>
                            <a href="{{ route('dashboard') }}" class="btn btn-secondary btn-lg">
                                <i class="fas fa-arrow-left mr-2"></i>Back to Dashboard
                            </a>
                        </div>
                    </div>
                </div>
            </div>
        </form>
    </div>
</section>

@include('components.whatsapp-qr-modal')
@endsection

@push('scripts')
<script>
$(document).ready(function() {
    // Update WhatsApp preview when template changes
    function updateWhatsAppPreview() {
        let template = $('#invoice_message_template').val();
        
        // Replace variables with sample data
        template = template.replace(/{invoice_number}/g, 'INV-2025-001');
        template = template.replace(/{customer_name}/g, 'John Doe');
        template = template.replace(/{customer_phone}/g, '+8801712345678');
        template = template.replace(/{invoice_date}/g, new Date().toLocaleDateString());
        template = template.replace(/{item_list}/g, '• iPhone 15 Pro x1 @ BDT 120,000 = BDT 120,000\n• Samsung Galaxy S24 x2 @ BDT 95,000 = BDT 190,000');
        template = template.replace(/{currency}/g, 'BDT');
        template = template.replace(/{total_amount}/g, '310,000.00');
        template = template.replace(/{payment_method}/g, 'Cash');
        template = template.replace(/{payment_status}/g, 'Paid');
        template = template.replace(/{invoice_link}/g, 'http://yoursite.com/invoice/INV-2025-001');
        
        $('#whatsappPreview').text(template);
    }

    // Initial preview update
    updateWhatsAppPreview();

    // Update preview when template changes
    $('#invoice_message_template').on('input', updateWhatsAppPreview);

    // Variable tag click to insert
    $('.variable-tag').click(function() {
        const variable = $(this).data('variable');
        const textarea = document.getElementById('invoice_message_template');
        const cursorPos = textarea.selectionStart;
        const textBefore = textarea.value.substring(0, cursorPos);
        const textAfter = textarea.value.substring(cursorPos);
        
        textarea.value = textBefore + variable + textAfter;
        textarea.selectionStart = textarea.selectionEnd = cursorPos + variable.length;
        textarea.focus();
        
        updateWhatsAppPreview();
    });

    // Form validation
    $('#settingsForm').on('submit', function(e) {
        const companyName = $('#company_name').val().trim();
        const headerText = $('#invoice_header_text').val().trim();
        const messageTemplate = $('#invoice_message_template').val().trim();

        if (!companyName) {
            alert('Company Name is required');
            e.preventDefault();
            return false;
        }

        if (!headerText) {
            alert('Invoice Header Text is required');
            e.preventDefault();
            return false;
        }

        if (!messageTemplate) {
            alert('WhatsApp Message Template is required');
            e.preventDefault();
            return false;
        }

        return true;
    });
});

function testQuickQr() {
    const countryCode = $('#whatsapp_country_code').val() || '+880';
    const phone = countryCode.replace('+', '') + '1712345678';
    const companyName = $('#company_name').val() || 'Your Mobile Store';
    
    const data = {
        customer_name: 'Test Customer',
        phone: phone,
        invoice_number: 'TEST-001',
        message: `🎉 Hello from ${companyName}!\n\nThis is a test message to verify our WhatsApp QR system is working properly.\n\n📱 Thank you for choosing us!`,
        whatsapp_url: `https://wa.me/${phone}?text=${encodeURIComponent(`Hello from ${companyName}! This is a test message.`)}`,
        qr_code_url: `https://api.qrserver.com/v1/create-qr-code/?size=300x300&data=${encodeURIComponent(`https://wa.me/${phone}?text=Hello from ${companyName}! This is a test message.`)}`,
        qr_code_url_alt: `https://chart.googleapis.com/chart?chs=300x300&cht=qr&chl=${encodeURIComponent(`https://wa.me/${phone}?text=Hello from ${companyName}! This is a test message.`)}&choe=UTF-8`
    };
    
    showWhatsAppQr(data);
}

function previewTemplate() {
    const template = $('#invoice_template').val();
    window.open(`{{ route('invoice-settings.preview') }}?template=${template}`, '_blank');
}
</script>
@endpush