{{-- {{ $product }} --}}

<!DOCTYPE html>
<html lang="en">

<head>
    <meta charset="UTF-8">
    <meta name="viewport" content="width=device-width, initial-scale=1.0">
    <title>Product Receipt</title>
    <style>
        body {
            font-family: 'Poppins', sans-serif;
            margin: 0;
            padding: 0;
            background-color: #f4f4f4;
            display: flex;
            justify-content: center;
            align-items: center;
            height: 100vh;
        }

        .receipt-container {
            width: 210mm;
            /* A4 width */
            height: auto;
            /* Adjust height for content */
            padding: 20mm;
            background-color: #ffffff;
            border-radius: 10px;
            box-shadow: 0 4px 8px rgba(0, 0, 0, 0.1);
            box-sizing: border-box;
            text-align: center;
        }

        .receipt-header {
            text-align: center;
            margin-bottom: 20px;
        }

        .receipt-header h1 {
            font-size: 24px;
            font-weight: 700;
            color: #007bff;
            margin: 0;
            text-transform: uppercase;
        }

        .receipt-header small {
            display: block;
            font-size: 14px;
            color: #6c757d;
        }

        .receipt-section {
            margin-bottom: 20px;
            padding-bottom: 10px;
            border-bottom: 2px dashed #dee2e6;
        }

        .section-title {
            font-size: 16px;
            font-weight: 600;
            margin-bottom: 10px;
            color: #495057;
        }

        .section-content p {
            margin: 5px 0;
            font-size: 14px;
            color: #212529;
        }

        .divider {
            border: 0;
            border-top: 2px dashed #ced4da;
            margin: 20px 0;
        }

        .cpr-box {
            margin: 20px auto;
            text-align: center;
            width: 85.6mm;
            height: 53.98mm;
            border: 2px dashed #007bff;
            border-radius: 8px;
            font-size: 14px;
            font-weight: bold;
            color: #007bff;
            display: flex;
            justify-content: center;
            align-items: center;
            background-color: #f8f9fa;
            box-sizing: border-box;
        }

        .signatures {
            margin-top: 30px;
            display: flex;
            justify-content: space-between;
            font-size: 14px;
            color: #6c757d;
        }

        .signatures div {
            text-align: center;
            width: 45%;
        }

        .signatures div hr {
            margin: 10px 0;
            border: none;
            border-top: 1px solid #ced4da;
        }

        .footer {
            text-align: center;
            font-size: 12px;
            color: #adb5bd;
            margin-top: 30px;
        }

        .action-buttons {
            margin-top: 20px;
            display: flex;
            justify-content: center;
            gap: 20px;
        }

        .action-buttons a,
        .action-buttons button {
            display: inline-block;
            padding: 10px 20px;
            font-size: 16px;
            font-weight: bold;
            color: #fff;
            background-color: #007bff;
            border: none;
            border-radius: 5px;
            text-decoration: none;
            box-shadow: 0 4px 6px rgba(0, 0, 0, 0.1);
            cursor: pointer;
            transition: background-color 0.3s ease;
        }

        .action-buttons a:hover,
        .action-buttons button:hover {
            background-color: #0056b3;
        }

        /* Print-specific styles */
        @media print {

            .action-buttons,
            .footer {
                display: none;
            }
        }
    </style>
</head>


<body onload="window.print();">

    <div class="receipt-container">
        <div class="receipt-header">
            <h1>Product Receipt</h1>
            <small>Date/Time: {{ date('d-m-Y H:i') }}</small>
        </div>

        <div class="section-title">Business Information</div>
        <div class="section-content">
            @if(isset($all_settings) && $all_settings)
                <p><strong>Company:</strong> {{ $all_settings->company_name ?? 'Mobile World Store' }}</p>
                @if($all_settings->address)
                    <p><strong>Address:</strong> {{ $all_settings->address }}</p>
                @endif
                <p><strong>Phone:</strong> {{ $all_settings->number ?? '+1-555-0123' }}</p>
                @if($all_settings->company_email)
                    <p><strong>Email:</strong> {{ $all_settings->company_email }}</p>
                @endif
                <p><strong>Reg. No:</strong> {{ $all_settings->company_registration_number ?? 'CR-123456789' }}</p>
            @else
                <p><strong>Company:</strong> {{ $location ? $location->name : 'Mobile World Store' }}</p>
                <p><strong>CR:</strong> {{ $location ? $location->business_registration_number : 'CR-123456789' }}</p>
                <p><strong>Mobile:</strong> {{ $location ? $location->mobile : '+1-555-0123' }}</p>
            @endif
            <small>Your Trusted Store</small>
        </div>

        <div class="receipt-section">
            <div class="section-title">Customer Details</div>
            <div class="section-content">
                <p><strong>Name:</strong>
                    {{ $product->customer ? $product->customer->name : '-' }}
                </p>
                <p><strong>Mobile:</strong>
                    {{ $product->customer ? $product->customer->number : '-' }}
                </p>
                <p><strong>CPR:</strong>
                    {{ $product->customer ? $product->customer->cpr : '-' }}
                </p>
            </div>
        </div>

        <div class="receipt-section">
            <div class="section-title">Product Details</div>
            <div class="section-content">
                <p>
                    <strong>Brand:</strong>
                    {{ $product->brand ?? '-' }}
                </p>
                <p>
                    <strong>Model:</strong>
                    {{ $product->model ?? '-' }}
                </p>
                <p>
                    <strong>IMEI/SN:</strong>
                    {{ $product->imei_or_sn ?? '-' }}
                </p>
                <p>
                    <strong>Storage/Color:</strong>
                    {{ $product->color ?? '-' }}
                </p>
                <p>
                    <strong>Condition:</strong>
                    {{ $product->condition ?? '-' }}
                </p>
                    <strong>Buy Price:</strong>
                    {{ env('APP_CURRENCY') }}
                    {{ $product->buy_price }}
                </p>
                <p>
                    <strong>Stock:</strong>
                    {{ $product->stock }}
                </p>
            </div>
        </div>

        <div class="cpr-box">CPR / ID BOX</div>

        <div class="divider"></div>

        <div class="signatures">
            <div>
                Customer Signature:
                <hr>
            </div>
            <div>
                Buyer Signature:
                <hr>
            </div>
        </div>

        {{-- <div class="action-buttons">
            <a href="view_receipt.php?id=<?php //echo $receipt_id;
            ?>" target="_blank" class="view-button">View Receipt</a>
            <a href="admin_panel.php?page=view_products" class="back-button">Back to Products</a>
        </div> --}}

        <div class="footer">
            &copy; 2025 Your Company. All Rights Reserved.
        </div>
    </div>

</body>

</html>
