@extends('layouts.app')

@section('main')
<!DOCTYPE html>
<html lang="en">
<head>
    <meta charset="UTF-8">
    <meta name="viewport" content="width=device-width, initial-scale=1.0">
    <title>Total Sales & Profit Report</title>
    <style>
        table {
            width: 100%;
            border-collapse: collapse;
        }
        table, th, td {
            border: 1px solid black;
        }
        th, td {
            padding: 10px;
            text-align: center;
        }
        .summary-boxes {
            display: flex;
            justify-content: space-around;
            margin-bottom: 20px;
        }
        .summary-box {
            border: 1px solid black;
            padding: 20px;
            text-align: center;
            width: 30%;
        }
        .filter-section {
            text-align: center;
            margin-bottom: 20px;
        }
        .filter-section label {
            margin-right: 10px;
        }
    </style>
</head>
<body>
    <h2 class="text-center mb-4">Sales & Profit Report for the Last 30 Days</h2>

    <div class="filter-section">
        <form method="GET" action="{{ route('report') }}">
            <label for="date-range">Filter by:</label>
            <select name="date_range" id="date-range" onchange="toggleCustomDateInputs(this.value)">
                <option value="week">Last Week</option>
                <option value="month" selected>Last Month</option>
                <option value="custom">Custom</option>
            </select>
            <div id="custom-date-inputs" style="display: none;">
                <label for="start-date">Start Date:</label>
                <input type="date" name="start_date" id="start-date">
                <label for="end-date">End Date:</label>
                <input type="date" name="end_date" id="end-date">
            </div>
            <button type="submit">Filter</button>
        </form>
    </div>

    <div class="summary-boxes">
        <div class="summary-box">
            <h3>Total Sales</h3>
            <p>{{ currency_format($totalSales) }}</p>
        </div>
        <div class="summary-box">
            <h3>Total Profit</h3>
            <p>{{ currency_format($totalProfit) }}</p>
        </div>
        <div class="summary-box">
            <h3>Net Profit</h3>
            <p>{{ currency_format($totalProfit - $totalCost) }}</p>
        </div>
    </div>

    <table>
        <thead>
            <tr>
                <th>Date</th>
                <th>Total Sales</th>
                <th>Total Profit</th>
                <th>Total Direct Sales</th>
                <th>Total Direct Profit</th>
            </tr>
        </thead>
        <tbody>
            @foreach ($reportData as $data)
                <tr>
                    <td>{{ $data['date'] }}</td>
                    <td>{{ currency_format($data['total_sales']) }}</td>
                    <td>{{ currency_format($data['total_profit']) }}</td>
                    <td>{{ currency_format($data['total_direct_sales']) }}</td>
                    <td>{{ currency_format($data['total_direct_profit']) }}</td>
                </tr>
            @endforeach
        </tbody>
    </table>

    <script>
        function toggleCustomDateInputs(value) {
            const customDateInputs = document.getElementById('custom-date-inputs');
            if (value === 'custom') {
                customDateInputs.style.display = 'block';
            } else {
                customDateInputs.style.display = 'none';
            }
        }
    </script>
</body>
</html>

<?php
// Helper function for currency formatting
function currency_format($value)
{
    return '$' . number_format($value, 2);
}
?>
@endsection