
    <h1>Edit Sale</h1>

    @if(session('success'))
        <div class="alert alert-success">{{ session('success') }}</div>
    @endif

    <form action="{{ route('sales.update', $sale) }}" method="POST">
        @csrf
        @method('PUT')

        <!-- Customer Selection -->
        <div>
            <label for="customer_id">Customer:</label>
            <select name="customer_id" id="customer_id" required>
                @foreach($customers as $customer)
                    <option value="{{ $customer->id }}" {{ $customer->id == $sale->customer_id ? 'selected' : '' }}>
                        {{ $customer->name }}
            
            </select>
        </div>

        <!-- Product Selection -->
        <div>
            <label for="products">Products:</label>
            <div id="product-list">
                @foreach($sale->products as $index => $product)
                    <select name="products[{{ $index }}][id]" required>
                        @foreach($products as $prod)
                            <option value="{{ $prod->id }}" {{ $prod->id == $product->id ? 'selected' : '' }}>
                                {{ $prod->name }} - ${{ $prod->buy_price }}
                            </option>
                        @endforeach
                    </select>
                    <input type="number" name="products[{{ $index }}][quantity]" value="{{ $product->pivot->quantity }}" placeholder="Quantity" required>
                    <input type="number" name="products[{{ $index }}][price]" value="{{ $product->pivot->price }}" placeholder="Price" required>
               
            </div>
        </div>

        <!-- Payment Method -->
        <div>
            <label for="payment_method">Payment Method:</label>
            <select name="payment_method" id="payment_method" required>
                <option value="cash" {{ $sale->payment_method == 'cash' ? 'selected' : '' }}>Cash</option>
                <option value="credit" {{ $sale->payment_method == 'credit' ? 'selected' : '' }}>Credit</option>
            </select>
        </div>

        <button type="submit">Update Sale</button>
    </form>

