@extends('layouts.app')

@push('style')
<!-- Toastr CSS -->
<link rel="stylesheet" href="https://cdnjs.cloudflare.com/ajax/libs/toastr.js/latest/toastr.min.css">
<style>
    /* Fix sidebar behavior */
    .sidebar-mini.sidebar-collapse .main-sidebar {
        width: 0;
    }
    
    .sidebar-mini:not(.sidebar-collapse) .main-sidebar {
        width: 250px;
    }
    
    /* Ensure sidebar stays fixed */
    .main-sidebar {
        position: fixed;
        top: 0;
        left: 0;
        height: 100vh;
        z-index: 1038;
        transition: all 0.3s ease;
    }
    
    /* Content wrapper adjustments */
    .content-wrapper {
        margin-left: 250px;
        transition: all 0.3s ease;
    }
    
    .sidebar-mini.sidebar-collapse .content-wrapper {
        margin-left: 0;
    }
    
    /* Mobile responsive fixes */
    @media (max-width: 991.98px) {
        .main-sidebar {
            margin-left: -250px;
        }
        
        .sidebar-open .main-sidebar {
            margin-left: 0;
        }
        
        .content-wrapper {
            margin-left: 0;
        }
        
        .sidebar-open .content-wrapper {
            transform: translateX(250px);
        }
    }
</style>
@endpush

@section('main')
    <!-- Content Header (Page header) -->
    <div class="content-header">
        <div class="container-fluid">
            <div class="row mb-2">
                <div class="col-sm-6">
                    <h1 class="m-0">Sales History</h1>
                </div>
                <div class="col-sm-6">
                    <ol class="breadcrumb float-sm-right">
                        <li class="breadcrumb-item"><a href="{{ route('dashboard') }}">Home</a></li>
                        <li class="breadcrumb-item"><a href="{{ route('sales.index') }}">Sales Management</a></li>
                        <li class="breadcrumb-item active">Sales History</li>
                    </ol>
                </div>
            </div>
        </div>
    </div>

    <!-- Main content -->
    <section class="content">
        <div class="container-fluid">
            <!-- Simple Summary Cards -->
            <div class="row">
                <div class="col-lg-3 col-6">
                    <div class="small-box bg-info">
                        <div class="inner">
                            <h3>{{ $sales->count() }}</h3>
                            <p>Total Sales</p>
                        </div>
                        <div class="icon">
                            <i class="fas fa-shopping-cart"></i>
                        </div>
                    </div>
                </div>
                <div class="col-lg-3 col-6">
                    <div class="small-box bg-success">
                        <div class="inner">
                            <h3>BHD {{ number_format($sales->sum('total_amount'), 2) }}</h3>
                            <p>Total Revenue</p>
                        </div>
                        <div class="icon">
                            <i class="fas fa-money-bill-wave"></i>
                        </div>
                    </div>
                </div>
                <div class="col-lg-3 col-6">
                    <div class="small-box bg-warning">
                        <div class="inner">
                            <h3>{{ $sales->where('payment_status', 'partial')->count() }}</h3>
                            <p>Partial Payments</p>
                        </div>
                        <div class="icon">
                            <i class="fas fa-exclamation-triangle"></i>
                        </div>
                    </div>
                </div>
                <div class="col-lg-3 col-6">
                    <div class="small-box bg-danger">
                        <div class="inner">
                            <h3>{{ $sales->where('payment_status', 'unpaid')->count() }}</h3>
                            <p>Unpaid Sales</p>
                        </div>
                        <div class="icon">
                            <i class="fas fa-times-circle"></i>
                        </div>
                    </div>
                </div>
            </div>

                <!-- Dynamic Exchange Summary Row -->
                <div class="row">
                    <div class="col-lg-3 col-12">
                        <div class="small-box bg-gradient-primary">
                            <div class="inner">
                                @php
                                    $totalSaleAmount = $sales->sum('total_amount');
                                    $totalExchangeValue = $sales->sum('total_exchange_value');
                                    $totalActualCash = $totalSaleAmount - $totalExchangeValue;
                                @endphp
                                <h3 id="totalActualCash">BHD {{ number_format($totalActualCash, 2) }}</h3>
                                <p>Total Actual Cash</p>
                                <small class="text-light" id="totalActualCashBreakdown">
                                    <i class="fas fa-calculator"></i> 
                                    Sales: {{ number_format($totalSaleAmount, 2) }} - 
                                    Exchanges: {{ number_format($totalExchangeValue, 2) }}
                                </small>
                            </div>
                            <div class="icon">
                                <i class="fas fa-hand-holding-usd"></i>
                            </div>
                        </div>
                    </div>
                    <div class="col-lg-3 col-12">
                        <div class="small-box bg-gradient-success">
                            <div class="inner">
                                <h3 id="salesWithExchanges">{{ $sales->where('has_exchanges', true)->count() }}</h3>
                                <p>Sales with Exchanges</p>
                                <small class="text-light" id="salesWithExchangesSubtext">Sales that included exchanges</small>
                            </div>
                            <div class="icon">
                                <i class="fas fa-exchange-alt"></i>
                            </div>
                        </div>
                    </div>
                    <div class="col-lg-3 col-12">
                        <div class="small-box bg-gradient-info">
                            <div class="inner">
                                <h3 id="totalExchangeItems">{{ $sales->sum('exchange_count') }}</h3>
                                <p>Total Exchange Items</p>
                                <small class="text-light" id="totalExchangeItemsSubtext">Individual items exchanged</small>
                            </div>
                            <div class="icon">
                                <i class="fas fa-mobile-alt"></i>
                            </div>
                        </div>
                    </div>
                    <div class="col-lg-3 col-12">
                        <div class="small-box bg-gradient-warning">
                            <div class="inner">
                                <h3 id="totalExchangeDiscount">BHD {{ number_format($sales->sum('total_exchange_value'), 2) }}</h3>
                                <p>Total Exchange Discount</p>
                                <small class="text-light" id="totalExchangeDiscountSubtext">
                                    <i class="fas fa-percent"></i> 
                                    {{ $totalSaleAmount > 0 ? number_format(($totalExchangeValue / $totalSaleAmount) * 100, 1) : 0 }}% of sales
                                </small>
                            </div>
                            <div class="icon">
                                <i class="fas fa-tags"></i>
                            </div>
                        </div>
                    </div>
                </div>

                <!-- Sales History Table -->
                <div class="row">
                    <div class="col-12">
                        <div class="card">
                            <div class="card-header">
                                <h3 class="card-title">
                                    <i class="fas fa-table mr-1"></i>
                                    Sales History
                                </h3>
                                <div class="card-tools">
                                    <button type="button" class="btn btn-tool" data-card-widget="collapse">
                                        <i class="fas fa-minus"></i>
                                    </button>
                                    <button type="button" class="btn btn-tool" data-card-widget="maximize">
                                        <i class="fas fa-expand"></i>
                                    </button>
                                </div>
                            </div>
                            <div class="card-body">
                                <!-- Advanced Filters -->
                                <div class="row mb-4">
                                    <div class="col-12">
                                        <div class="card card-outline card-primary">
                                            <div class="card-header">
                                                <h3 class="card-title">
                                                    <i class="fas fa-filter mr-2"></i>Advanced Filters
                                                    <span class="badge badge-success badge-sm ml-2">
                                                        <i class="fas fa-bolt"></i> Auto-Apply
                                                    </span>
                                                </h3>
                                                <div class="card-tools">
                                                    <button type="button" class="btn btn-tool" data-card-widget="collapse">
                                                        <i class="fas fa-minus"></i>
                                                    </button>
                                                </div>
                                            </div>
                                            <div class="card-body">
                                                <div class="row">
                                                    <!-- Date Filter -->
                                                    <div class="col-lg-4 col-md-6 col-12 mb-3">
                                                        <label for="dateFilter" class="font-weight-bold">
                                                            <i class="fas fa-calendar-alt text-primary"></i> Date Filter
                                                        </label>
                                                        <select id="dateFilter" class="form-control">
                                                            <option value="all">All Dates</option>
                                                            <option value="today">Today</option>
                                                            <option value="yesterday">Yesterday</option>
                                                            <option value="last7">Last 7 Days</option>
                                                            <option value="last30">Last 30 Days</option>
                                                            <option value="last90">Last 90 Days</option>
                                                            <option value="last365">Last Year</option>
                                                            <option value="custom">Custom Date Range</option>
                                                        </select>
                                                    </div>

                                                    <!-- Custom Date Range -->
                                                    <div class="col-lg-4 col-md-6 col-12 mb-3" id="customDateRange" style="display: none;">
                                                        <label class="font-weight-bold">
                                                            <i class="fas fa-calendar-check text-success"></i> Custom Date Range
                                                        </label>
                                                        <div class="row">
                                                            <div class="col-6">
                                                                <input type="date" id="startDate" class="form-control" placeholder="Start Date">
                                                            </div>
                                                            <div class="col-6">
                                                                <input type="date" id="endDate" class="form-control" placeholder="End Date">
                                                            </div>
                                                        </div>
                                                    </div>

                                                    <!-- Sale Type Filter -->
                                                    <div class="col-lg-2 col-md-6 col-12 mb-3">
                                                        <label for="saleTypeFilter" class="font-weight-bold">
                                                            <i class="fas fa-tags text-info"></i> Sale Type
                                                        </label>
                                                        <select id="saleTypeFilter" class="form-control">
                                                            <option value="all">All Types</option>
                                                            <option value="regular_sale">Regular Sales</option>
                                                            <option value="direct_sale">Direct Sales</option>
                                                            <option value="with_exchange">With Exchange</option>
                                                        </select>
                                                    </div>

                                                    <!-- Payment Status Filter -->
                                                    <div class="col-lg-2 col-md-6 col-12 mb-3">
                                                        <label for="paymentStatusFilter" class="font-weight-bold">
                                                            <i class="fas fa-credit-card text-warning"></i> Payment Status
                                                        </label>
                                                        <select id="paymentStatusFilter" class="form-control">
                                                            <option value="all">All Status</option>
                                                            <option value="paid">Paid</option>
                                                            <option value="unpaid">Unpaid</option>
                                                            <option value="partial">Partial</option>
                                                        </select>
                                                    </div>
                                                </div>

                                                <div class="row">
                                                    <!-- Global Search -->
                                                    <div class="col-lg-6 col-md-8 col-12 mb-3">
                                                        <label for="globalSearch" class="font-weight-bold">
                                                            <i class="fas fa-search text-primary"></i> Global Search
                                                        </label>
                                                        <input type="text" id="globalSearch" class="form-control" placeholder="Search by customer name, sale ID, phone, etc...">
                                                    </div>

                                                    <!-- Filter Actions -->
                                                    <div class="col-lg-6 col-md-4 col-12 mb-3">
                                                        <label class="font-weight-bold">
                                                            <i class="fas fa-cogs text-secondary"></i> Actions
                                                        </label>
                                                        <div class="btn-group d-block">
                                                            <button type="button" id="clearFilters" class="btn btn-secondary">
                                                                <i class="fas fa-times"></i> Clear All
                                                            </button>
                                                            <button type="button" id="exportFiltered" class="btn btn-success">
                                                                <i class="fas fa-download"></i> Export
                                                            </button>
                                                            <button type="button" class="btn btn-info" data-toggle="tooltip" data-html="true" title="<b>Keyboard Shortcuts:</b><br>F - Focus Search<br>Ctrl+C - Clear Filters<br>Ctrl+E - Export<br>Ctrl+1 - Today Filter<br>Ctrl+7 - Last 7 Days<br><br><b>Auto-Filters:</b><br>All filters apply instantly when changed!">
                                                                <i class="fas fa-keyboard"></i> Help
                                                            </button>
                                                            <button type="button" id="testFilter" class="btn btn-warning" onclick="testDateFilter()">
                                                                <i class="fas fa-bug"></i> Test
                                                            </button>
                                                        </div>
                                                    </div>
                                                </div>
                                            </div>
                                        </div>
                                    </div>
                                </div>

                                <div class="table-responsive">
                                    <!-- Filter Summary -->
                                    <div id="filterSummary" class="alert alert-info" style="display: none;">
                                        <i class="fas fa-filter"></i>
                                        <strong>Active Filters:</strong>
                                        <span id="filterSummaryText"></span>
                                        <button type="button" class="close" onclick="$('#clearFilters').click();">
                                            <span>&times;</span>
                                        </button>
                                    </div>

                                    <table id="salesTable" class="table table-bordered table-striped table-hover">
                                        <thead class="thead-dark">
                                            <tr>
                                                <th><i class="fas fa-hashtag"></i> ID</th>
                                                <th><i class="fas fa-calendar"></i> Date</th>
                                                <th><i class="fas fa-user"></i> Customer</th>
                                                <th><i class="fas fa-boxes"></i> Items</th>
                                                <th><i class="fas fa-tag"></i> Brand/Model</th>
                                                <th><i class="fas fa-barcode"></i> IMEI/SN</th>
                                                <th><i class="fas fa-dollar-sign"></i> Actual Cash</th>
                                                <th><i class="fas fa-credit-card"></i> Payment Method</th>
                                                <th><i class="fas fa-check-circle"></i> Status</th>
                                                <th><i class="fas fa-cog"></i> Actions</th>
                                            </tr>
                                        </thead>
                                        <tbody>
                                            @foreach ($sales as $sale)
                                                <tr data-sale-id="{{ $sale->id }}"
                                                    data-sale-type="{{ $sale->type ?? 'regular_sale' }}"
                                                    data-transactions="{{ $sale->sellTransactions->toJson() }}"
                                                    data-exchanges="{{ $sale->exchanges->toJson() }}">
                                                    <td>
                                                        <strong>#{{ $sale->id }}</strong>
                                                        @if(isset($sale->type) && $sale->type == 'direct_sale')
                                                            <br><span class="badge badge-warning badge-sm">Direct Sale</span>
                                                        @else
                                                            <br><span class="badge badge-primary badge-sm">Regular Sale</span>
                                                            @if(isset($sale->has_exchanges) && $sale->has_exchanges)
                                                                <br><span class="badge badge-success badge-sm">
                                                                    <i class="fas fa-exchange-alt"></i> With Exchange
                                                                </span>
                                                            @endif
                                                        @endif
                                                    </td>
                                                    <td>
                                                        <span class="badge badge-light">
                                                            {{ $sale->created_at->format('d M Y') }}
                                                        </span><br>
                                                        <small class="text-muted">{{ $sale->created_at->format('H:i A') }}</small>
                                                    </td>
                                                    <td>
                                                        @if(isset($sale->type) && $sale->type == 'direct_sale')
                                                            @if($sale->customer)
                                                                <strong>{{ $sale->customer->name }}</strong><br>
                                                                <small class="text-muted">{{ $sale->customer->phone ?? 'N/A' }}</small>
                                                            @else
                                                                <strong>{{ $sale->customer_name ?? 'Direct Customer' }}</strong><br>
                                                                <small class="text-muted">Direct Sale</small>
                                                            @endif
                                                        @else
                                                            @if($sale->customer)
                                                                <strong>{{ $sale->customer->name }}</strong><br>
                                                                <small class="text-muted">{{ $sale->customer->phone ?? 'N/A' }}</small>
                                                            @else
                                                                <span class="text-muted">Walk-in Customer</span>
                                                            @endif
                                                        @endif
                                                    </td>
                                                    <td>
                                                        @if(isset($sale->type) && $sale->type == 'direct_sale')
                                                            <span class="badge badge-warning">{{ $sale->quantity ?? 1 }} items</span>
                                                            <span class="text-muted">{{ $sale->product_type ?? 'Direct Product' }}</span>
                                                        @else
                                                            <span class="badge badge-info">{{ $sale->sellTransactions->count() }} items</span>
                                                            @if(isset($sale->has_exchanges) && $sale->has_exchanges)
                                                                <br><span class="badge badge-success badge-sm">
                                                                    <i class="fas fa-exchange-alt"></i> {{ $sale->exchange_count }} Exchange{{ $sale->exchange_count > 1 ? 's' : '' }}
                                                                </span>
                                                                <br><small class="text-success">Exchange Value: BHD {{ number_format($sale->total_exchange_value, 2) }}</small>
                                                            @endif
                                                        @endif
                                                        <button class="btn btn-xs btn-outline-primary ml-1 toggle-items" data-toggle="tooltip" title="View Items">
                                                            <i class="fas fa-eye"></i>
                                                        </button>
                                                    </td>
                                                    <td>
                                                        @if(isset($sale->type) && $sale->type == 'direct_sale')
                                                            <!-- Direct Sale Brand/Model -->
                                                            @if(isset($sale->product_brand) && isset($sale->product_model))
                                                                <span class="badge badge-warning">{{ $sale->product_brand }}</span><br>
                                                                <small class="text-muted">{{ $sale->product_model }}</small>
                                                            @else
                                                                <span class="text-muted">Direct Sale</span><br>
                                                                <small class="text-muted">{{ $sale->product_type ?? 'Product' }}</small>
                                                            @endif
                                                        @else
                                                            <!-- Regular Sale Brand/Model -->
                                                            @php
                                                                $firstTransaction = $sale->sellTransactions->first();
                                                                $totalTransactions = $sale->sellTransactions->count();
                                                            @endphp
                                                            
                                                            @if($firstTransaction && $firstTransaction->product)
                                                                <span class="badge badge-info">{{ $firstTransaction->product->brand ?? 'N/A' }}</span><br>
                                                                <small class="text-muted">{{ $firstTransaction->product->model ?? 'N/A' }}</small>
                                                                @if($totalTransactions > 1)
                                                                    <br><small class="text-primary">+{{ $totalTransactions - 1 }} more</small>
                                                                @endif
                                                            @else
                                                                <span class="text-muted">No Product</span><br>
                                                                <small class="text-muted">Data</small>
                                                            @endif
                                                        @endif
                                                    </td>
                                                    <td>
                                                        @if(isset($sale->type) && $sale->type == 'direct_sale')
                                                            <!-- Direct Sale IMEI/SN -->
                                                            @if(isset($sale->imei_or_sn))
                                                                <code class="text-dark">{{ $sale->imei_or_sn }}</code>
                                                            @else
                                                                <span class="text-muted">N/A</span>
                                                            @endif
                                                        @else
                                                            <!-- Regular Sale IMEI/SN -->
                                                            @if($firstTransaction && $firstTransaction->product)
                                                                <code class="text-dark">{{ $firstTransaction->product->imei_or_sn ?? 'N/A' }}</code>
                                                                @if($totalTransactions > 1)
                                                                    <br><small class="text-primary">Multiple items</small>
                                                                @endif
                                                            @else
                                                                <span class="text-muted">N/A</span>
                                                            @endif
                                                        @endif
                                                    </td>
                                                    <td>
                                                        @php
                                                            $saleAmount = $sale->net_amount ?? $sale->total_amount;
                                                            $exchangeValue = $sale->total_exchange_value ?? 0;
                                                            $actualCash = $saleAmount - $exchangeValue;
                                                        @endphp
                                                        
                                                        <strong class="text-success">BHD {{ number_format($actualCash, 2) }}</strong>
                                                        <br><small class="text-muted">Actual Cash Received</small>
                                                        
                                                        @if($exchangeValue > 0)
                                                            <br><small class="text-info">
                                                                Sale: BHD {{ number_format($saleAmount, 2) }}
                                                            </small>
                                                            <br><small class="text-warning">
                                                                <i class="fas fa-minus-circle"></i> Exchange: BHD {{ number_format($exchangeValue, 2) }}
                                                            </small>
                                                        @endif
                                                        
                                                        @if(isset($sale->due_amount) && $sale->due_amount > 0)
                                                            <br><small class="text-danger">Due: BHD {{ number_format($sale->due_amount, 2) }}</small>
                                                        @endif
                                                        @if(isset($sale->type) && $sale->type == 'direct_sale' && isset($sale->profit))
                                                            <br><small class="text-success">Profit: BHD {{ number_format($sale->profit, 2) }}</small>
                                                        @endif
                                                    </td>
                                                    <td>
                                                        <span class="badge badge-secondary">{{ ucfirst($sale->payment_method) }}</span>
                                                    </td>
                                                    <td>
                                                        @if ($sale->payment_status == 'paid')
                                                            <span class="badge badge-success"><i class="fas fa-check"></i> Paid</span>
                                                        @elseif($sale->payment_status == 'unpaid')
                                                            <span class="badge badge-danger"><i class="fas fa-times"></i> Unpaid</span>
                                                        @elseif($sale->payment_status == 'partial')
                                                            <span class="badge badge-warning"><i class="fas fa-clock"></i> Partial</span>
                                                        @else
                                                            <span class="badge badge-secondary">{{ ucfirst($sale->payment_status) }}</span>
                                                        @endif
                                                    </td>
                                                    <td>
                                                        <!-- Consolidated Action Buttons -->
                                                        <div class="btn-group" role="group">
                                                            <!-- Quick Actions (Most Used) -->
                                                            <button class="btn btn-sm btn-info toggle-items" 
                                                                    data-toggle="tooltip" 
                                                                    title="View Items" 
                                                                    data-placement="top">
                                                                <i class="fas fa-eye"></i>
                                                            </button>
                                                            
                                                            @if(isset($sale->type) && $sale->type == 'direct_sale')
                                                                <!-- Direct Sale Actions -->
                                                                <a href="{{ route('direct-sales.invoice', str_replace('DS-', '', $sale->id)) }}" 
                                                                   target="_blank" 
                                                                   class="btn btn-sm btn-primary" 
                                                                   data-toggle="tooltip" 
                                                                   title="Print Direct Sale Receipt" 
                                                                   data-placement="top">
                                                                    <i class="fas fa-print"></i>
                                                                </a>
                                                            @else
                                                                <!-- Regular Sale Actions -->
                                                                <a href="{{ route('sales.table.invoice', $sale->id) }}" 
                                                                   target="_blank" 
                                                                   class="btn btn-sm btn-primary" 
                                                                   data-toggle="tooltip" 
                                                                   title="Print Receipt" 
                                                                   data-placement="top">
                                                                    <i class="fas fa-print"></i>
                                                                </a>
                                                                
                                                                @if($sale->payment_status != 'paid')
                                                                    <button class="btn btn-sm btn-success mark-paid" 
                                                                            data-sale-id="{{ $sale->id }}" 
                                                                            data-toggle="tooltip" 
                                                                            title="Mark as Paid" 
                                                                            data-placement="top">
                                                                        <i class="fas fa-check-circle"></i>
                                                                    </button>
                                                                @endif
                                                            @endif
                                                            
                                                            <!-- More Actions Dropdown -->
                                                            <div class="btn-group" role="group">
                                                                <button class="btn btn-sm btn-outline-secondary dropdown-toggle" 
                                                                        type="button" 
                                                                        data-toggle="dropdown" 
                                                                        aria-haspopup="true" 
                                                                        aria-expanded="false"
                                                                        data-toggle="tooltip" 
                                                                        title="More Actions">
                                                                    <i class="fas fa-ellipsis-v"></i>
                                                                </button>
                                                                <div class="dropdown-menu dropdown-menu-right">
                                                                    <h6 class="dropdown-header">
                                                                        <i class="fas fa-cog"></i> 
                                                                        @if(isset($sale->type) && $sale->type == 'direct_sale')
                                                                            Direct Sale Actions
                                                                        @else
                                                                            Sale Actions
                                                                        @endif
                                                                    </h6>
                                                                    
                                                                    <button class="dropdown-item toggle-details" type="button">
                                                                        <i class="fas fa-info-circle text-info"></i> View Details
                                                                    </button>
                                                                    
                                                                    @if(isset($sale->type) && $sale->type == 'direct_sale')
                                                                        <!-- Direct Sale Specific Actions -->
                                                                        <a class="dropdown-item" href="{{ route('direct-sales.invoice', str_replace('DS-', '', $sale->id)) }}" target="_blank">
                                                                            <i class="fas fa-file-invoice text-primary"></i> Full Invoice
                                                                        </a>
                                                                    @else
                                                                        <!-- Regular Sale Specific Actions -->
                                                                        <button class="dropdown-item quick-invoice" data-sale-id="{{ $sale->id }}" type="button">
                                                                            <i class="fas fa-receipt text-dark"></i> Quick Print
                                                                        </button>
                                                                        
                                                                        <a class="dropdown-item" href="{{ route('sales.table.invoice', $sale->id) }}" target="_blank">
                                                                            <i class="fas fa-file-invoice text-primary"></i> Full Invoice
                                                                        </a>
                                                                        
                                                                        @if($sale->payment_status != 'paid')
                                                                            <div class="dropdown-divider"></div>
                                                                            <h6 class="dropdown-header"><i class="fas fa-edit"></i> Modify</h6>
                                                                            
                                                                            <a class="dropdown-item" href="{{ route('sales.edit', $sale->id) }}">
                                                                                <i class="fas fa-edit text-warning"></i> Edit Sale
                                                                            </a>
                                                                        @endif
                                                                    @endif
                                                                    
                                                                    @if($sale->customer)
                                                                        <div class="dropdown-divider"></div>
                                                                        <a class="dropdown-item" href="{{ route('customers.show', $sale->customer->id) }}">
                                                                            <i class="fas fa-user text-info"></i> View Customer
                                                                        </a>
                                                                    @endif
                                                                    
                                                                    <div class="dropdown-divider"></div>
                                                                    <h6 class="dropdown-header text-danger"><i class="fas fa-exclamation-triangle"></i> Danger Zone</h6>
                                                                    @if(isset($sale->type) && $sale->type == 'direct_sale')
                                                                        <button class="dropdown-item text-danger" onclick="confirmDirectSaleDelete('{{ str_replace('DS-', '', $sale->id) }}')" type="button">
                                                                            <i class="fas fa-trash"></i> Delete Direct Sale
                                                                        </button>
                                                                    @else
                                                                        <button class="dropdown-item text-danger" onclick="confirmDelete({{ $sale->id }})" type="button">
                                                                            <i class="fas fa-trash"></i> Delete Sale
                                                                        </button>
                                                                    @endif
                                                                </div>
                                                            </div>
                                                        </div>
                                                        
                                                        <!-- Hidden forms for delete fallback -->
                                                        @if(isset($sale->type) && $sale->type == 'direct_sale')
                                                            <form id="delete-direct-form-{{ str_replace('DS-', '', $sale->id) }}" action="{{ route('direct-sales.destroy', str_replace('DS-', '', $sale->id)) }}" method="POST" style="display: none;">
                                                                @csrf
                                                                @method('DELETE')
                                                            </form>
                                                        @else
                                                            <form id="delete-form-{{ $sale->id }}" action="{{ route('sales.destroy', $sale->id) }}" method="POST" style="display: none;">
                                                                @csrf
                                                                @method('DELETE')
                                                            </form>
                                                        @endif
                                                    </td>
                                                </tr>
                                            @endforeach
                                        </tbody>
                                        <tfoot class="thead-light">
                                            <tr>
                                                <th colspan="6"><strong>Totals:</strong></th>
                                                <th><strong>BHD {{ number_format($sales->sum('total_amount'), 2) }}</strong></th>
                                                <th colspan="3"></th>
                                            </tr>
                                        </tfoot>
                                    </table>
                                </div>
                            </div>
                            <!-- Pagination -->
                            <div class="card-footer clearfix">
                                {{ $sales->links() }}
                            </div>
                        </div>
                    </div>
                </div>

            </div>
        </section>

    <!-- Hidden iframe for printing -->
    <iframe id="printFrame" style="display: none;"></iframe>
@endsection

@push('script')
    <script>
        // GLOBAL DELETE FUNCTIONS
        function confirmDelete(saleId) {
            console.log('Delete function called for sale ID:', saleId);
            
            // Use modern confirmation dialog if available, fallback to native confirm
            if (typeof notificationSystem !== 'undefined' && notificationSystem.confirm) {
                notificationSystem.confirm({
                    title: 'Delete Sale?',
                    message: 'This action cannot be undone and will remove:\n• Sale record\n• Associated transactions\n• Payment records\n• Exchange records',
                    type: 'danger',
                    confirmText: 'Delete Sale',
                    cancelText: 'Cancel',
                    onConfirm: () => {
                        performSaleDeletion(saleId);
                    },
                    onCancel: () => {
                        console.log('User cancelled deletion');
                    }
                });
            } else if (confirm('⚠️ Are you sure you want to delete this sale?\n\nThis action cannot be undone and will remove:\n• Sale record\n• Associated transactions\n• Payment records\n• Exchange records\n\nClick OK to proceed or Cancel to abort.')) {
                performSaleDeletion(saleId);
            } else {
                console.log('User cancelled deletion');
            }
        }

        // Extracted deletion logic
        function performSaleDeletion(saleId) {
            console.log('Performing deletion for sale ID:', saleId);
            
            // Show loading state
            var deleteBtn = $('[onclick="confirmDelete(' + saleId + ')"]');
            var originalText = deleteBtn.html();
            deleteBtn.html('<i class="fas fa-spinner fa-spin"></i> Deleting...');
            deleteBtn.prop('disabled', true);
                
            // Get CSRF token
            var csrfToken = $('meta[name="csrf-token"]').attr('content');
            console.log('CSRF Token:', csrfToken);
            
            // Check if jQuery is available
            if (typeof $ === 'undefined') {
                console.log('jQuery not available, using form submission');
                document.getElementById('delete-form-' + saleId).submit();
                return;
            }
            
            $.ajax({
                url: '/sales/' + saleId,
                method: 'DELETE',
                headers: {
                    'X-CSRF-TOKEN': csrfToken,
                    'Content-Type': 'application/json',
                    'Accept': 'application/json'
                },
                data: JSON.stringify({
                    _token: csrfToken
                }),
                success: function(response) {
                    console.log('Delete response:', response);
                    if (response.success) {
                        // Show enhanced delete notification with sound
                        if (typeof notificationSystem !== 'undefined') {
                            notificationSystem.delete('Sale Deleted!', 'Sale record has been permanently removed');
                        } else {
                            alert('✅ Sale deleted successfully');
                        }
                        
                        // Remove the deleted row from DataTable
                        var table = $('#salesTable').DataTable();
                        var row = deleteBtn.closest('tr');
                        table.row(row).remove().draw(false); // false keeps current page
                    } else {
                        if (typeof notificationSystem !== 'undefined') {
                            notificationSystem.showError(response.message || 'Failed to delete sale', 'Delete Failed');
                        } else {
                            alert('❌ Error: ' + (response.message || 'Failed to delete sale'));
                        }
                        deleteBtn.html(originalText);
                        deleteBtn.prop('disabled', false);
                    }
                },
                error: function(xhr, status, error) {
                    console.log('AJAX Delete failed, trying form submission fallback');
                    console.log('Delete error:', xhr.responseText, status, error);
                    console.log('Status Code:', xhr.status);
                    
                    // Fallback to form submission
                    document.getElementById('delete-form-' + saleId).submit();
                }
            });
        }

        // Direct sales delete function
        function confirmDirectSaleDelete(directSaleId) {
            console.log('Direct sale delete function called for ID:', directSaleId);
            
            // Use modern confirmation dialog if available, fallback to native confirm
            if (typeof notificationSystem !== 'undefined' && notificationSystem.confirm) {
                notificationSystem.confirm({
                    title: 'Delete Direct Sale?',
                    message: 'This action cannot be undone and will remove:\n• Direct sale record\n• All associated data',
                    type: 'danger',
                    confirmText: 'Delete Direct Sale',
                    cancelText: 'Cancel',
                    onConfirm: () => {
                        performDirectSaleDeletion(directSaleId);
                    },
                    onCancel: () => {
                        console.log('User cancelled direct sale deletion');
                    }
                });
            } else if (confirm('⚠️ Are you sure you want to delete this direct sale?\n\nThis action cannot be undone and will remove:\n• Direct sale record\n• All associated data\n\nClick OK to proceed or Cancel to abort.')) {
                performDirectSaleDeletion(directSaleId);
            } else {
                console.log('User cancelled direct sale deletion');
            }
        }

        // Extracted direct sale deletion logic
        function performDirectSaleDeletion(directSaleId) {
            console.log('Performing direct sale deletion for ID:', directSaleId);
            
            // Show loading state
            var deleteBtn = $('[onclick="confirmDirectSaleDelete(\'' + directSaleId + '\')"]');
            var originalText = deleteBtn.html();
            deleteBtn.html('<i class="fas fa-spinner fa-spin"></i> Deleting...');
            deleteBtn.prop('disabled', true);
                
            // Get CSRF token
            var csrfToken = $('meta[name="csrf-token"]').attr('content');
            console.log('CSRF Token:', csrfToken);
            
            // Check if jQuery is available
            if (typeof $ === 'undefined') {
                console.log('jQuery not available, using form submission');
                document.getElementById('delete-direct-form-' + directSaleId).submit();
                return;
            }
            
            $.ajax({
                url: '/direct-sales/' + directSaleId,
                method: 'DELETE',
                headers: {
                    'X-CSRF-TOKEN': csrfToken,
                    'Content-Type': 'application/json',
                    'Accept': 'application/json'
                },
                data: JSON.stringify({
                    _token: csrfToken
                }),
                success: function(response) {
                    console.log('Direct sale delete response:', response);
                    if (response.success) {
                        // Show enhanced delete notification with sound
                        if (typeof notificationSystem !== 'undefined') {
                            notificationSystem.delete('Direct Sale Deleted!', 'Direct sale record has been permanently removed');
                        } else {
                            alert('✅ Direct sale deleted successfully');
                        }
                        
                        // Remove the deleted row from DataTable
                        var table = $('#salesTable').DataTable();
                        var row = deleteBtn.closest('tr');
                        table.row(row).remove().draw(false); // false keeps current page
                    } else {
                        if (typeof notificationSystem !== 'undefined') {
                            notificationSystem.showError(response.message || 'Failed to delete direct sale', 'Delete Failed');
                        } else {
                            alert('❌ Error: ' + (response.message || 'Failed to delete direct sale'));
                        }
                        deleteBtn.html(originalText);
                        deleteBtn.prop('disabled', false);
                    }
                },
                error: function(xhr, status, error) {
                    console.log('AJAX Direct sale delete failed, trying form submission fallback');
                    console.log('Delete error:', xhr.responseText, status, error);
                    console.log('Status Code:', xhr.status);
                    
                    // Fallback to form submission
                    document.getElementById('delete-direct-form-' + directSaleId).submit();
                }
            });
        }
        
        $(document).ready(function() {
            // Initialize DataTables
            $('#salesTable').DataTable({
                "paging": true,
                "lengthChange": true,
                "searching": true,
                "ordering": true,
                "info": true,
                "autoWidth": false,
                "responsive": true,
                "pageLength": 25,
                "order": [[1, "desc"]]
            });
            
            // Debug: Make sure functions are available globally
            console.log('Delete functions loaded:', {
                confirmDelete: typeof confirmDelete,
                confirmDirectSaleDelete: typeof confirmDirectSaleDelete
            });
        });
    </script>
@endpush
