<!-- Sales Transaction Actions -->
<div class="btn-group" role="group">
    <a href="{{ route('sale.invoice', $sale->sale_id ?? $sale->id) }}" class="btn btn-info btn-sm" title="View Invoice">
        <i class="fas fa-file-invoice"></i>
    </a>
    <button type="button" class="btn btn-warning btn-sm" onclick="editSale({{ $sale->id }})" title="Edit">
        <i class="fas fa-edit"></i>
    </button>
    <button type="button" class="btn btn-danger btn-sm" onclick="deleteSale({{ $sale->id }})" title="Delete">
        <i class="fas fa-trash"></i>
    </button>
</div>

@push('script')
<script>
function editSale(saleId) {
    // Redirect to edit page or show modal
    window.location.href = `/sale/${saleId}/edit`;
}

function deleteSale(saleId) {
    Swal.fire({
        title: 'Are you sure?',
        text: "This will delete the sale and restore product stock!",
        icon: 'warning',
        showCancelButton: true,
        confirmButtonColor: '#dc3545',
        cancelButtonColor: '#6c757d',
        confirmButtonText: 'Yes, delete it!'
    }).then((result) => {
        if (result.isConfirmed) {
            // Send delete request
            $.ajax({
                url: `/sale/${saleId}`,
                method: 'DELETE',
                data: {
                    _token: $('meta[name="csrf-token"]').attr('content')
                },
                success: function(response) {
                    Swal.fire('Deleted!', 'Sale has been deleted and stock restored.', 'success');
                    // Reload the table if it exists
                    if ($.fn.DataTable.isDataTable('#sales-table')) {
                        $('#sales-table').DataTable().ajax.reload();
                    } else {
                        location.reload();
                    }
                },
                error: function(xhr) {
                    Swal.fire('Error!', 'Failed to delete sale.', 'error');
                }
            });
        }
    });
}
</script>
@endpush