@extends('layouts.app')

@section('main')
    <div class="content-wrapper">
        <!-- Content Header (Page header) -->
        <div class="content-header">
            <div class="container-fluid">
                <div class="row mb-2">
                    <div class="col-sm-6">
                        <h1 class="m-0">
                            <i class="fas fa-cogs mr-2"></i>Company Settings
                        </h1>
                    </div>
                    <div class="col-sm-6">
                        <ol class="breadcrumb float-sm-right">
                            <li class="breadcrumb-item"><a href="{{ route('home') }}">Home</a></li>
                            <li class="breadcrumb-item active">Settings</li>
                        </ol>
                    </div>
                </div>
            </div>
        </div>

        <!-- Main content -->
        <section class="content">
            <div class="container-fluid">
                @if (session('success'))
                    <div class="alert alert-success alert-dismissible fade show">
                        <button type="button" class="close" data-dismiss="alert" aria-hidden="true">×</button>
                        <i class="icon fas fa-check"></i>
                        {{ session('success') }}
                    </div>
                @endif

                @if ($errors->any())
                    <div class="alert alert-danger alert-dismissible fade show">
                        <button type="button" class="close" data-dismiss="alert" aria-hidden="true">×</button>
                        <i class="icon fas fa-ban"></i>
                        <ul class="mb-0">
                            @foreach ($errors->all() as $error)
                                <li>{{ $error }}</li>
                            @endforeach
                        </ul>
                    </div>
                @endif

                <form action="{{ route('settings.update', 1) }}" method="POST" enctype="multipart/form-data">
                    @csrf
                    @method('PUT')
                    
                    <div class="row">
                        <!-- Company Information Card -->
                        <div class="col-md-6">
                            <div class="card card-primary">
                                <div class="card-header">
                                    <h3 class="card-title">
                                        <i class="fas fa-building mr-2"></i>Company Information
                                    </h3>
                                </div>
                                <div class="card-body">
                                    <div class="form-group">
                                        <label for="company_name">
                                            <i class="fas fa-tag mr-1"></i>Company Name
                                        </label>
                                        <input type="text" id="company_name" name="company_name" 
                                               class="form-control @error('company_name') is-invalid @enderror"
                                               value="{{ old('company_name', $settings->company_name) }}" 
                                               placeholder="Enter company name" required>
                                        @error('company_name')
                                            <span class="invalid-feedback">{{ $message }}</span>
                                        @enderror
                                    </div>

                                    <div class="form-group">
                                        <label for="company_registration_name">
                                            <i class="fas fa-building mr-1"></i>Company Registration Name
                                            <small class="text-muted">(Optional)</small>
                                        </label>
                                        <input type="text" id="company_registration_name" name="company_registration_name" 
                                               class="form-control @error('company_registration_name') is-invalid @enderror"
                                               value="{{ old('company_registration_name', $settings->company_registration_name ?? '') }}" 
                                               placeholder="Enter official registration name">
                                        @error('company_registration_name')
                                            <span class="invalid-feedback">{{ $message }}</span>
                                        @enderror
                                        <small class="text-muted">This will appear in bold under the company name on invoices</small>
                                    </div>

                                    <div class="form-group">
                                        <label for="number">
                                            <i class="fas fa-phone mr-1"></i>Phone Number
                                        </label>
                                        <input type="text" id="number" name="number" 
                                               class="form-control @error('number') is-invalid @enderror"
                                               value="{{ old('number', $settings->number) }}" 
                                               placeholder="Enter phone number" required>
                                        @error('number')
                                            <span class="invalid-feedback">{{ $message }}</span>
                                        @enderror
                                    </div>

                                    <div class="form-group">
                                        <label for="address">
                                            <i class="fas fa-map-marker-alt mr-1"></i>Address
                                        </label>
                                        <textarea id="address" name="address" rows="3"
                                                  class="form-control @error('address') is-invalid @enderror"
                                                  placeholder="Enter complete address" required>{{ old('address', $settings->address) }}</textarea>
                                        @error('address')
                                            <span class="invalid-feedback">{{ $message }}</span>
                                        @enderror
                                        <small class="text-muted">This address will appear on all invoices and receipts</small>
                                    </div>

                                    <div class="form-group">
                                        <label for="company_registration_number">
                                            <i class="fas fa-certificate mr-1"></i>Registration Number
                                        </label>
                                        <input type="text" id="company_registration_number" name="company_registration_number" 
                                               class="form-control @error('company_registration_number') is-invalid @enderror"
                                               value="{{ old('company_registration_number', $settings->company_registration_number) }}" 
                                               placeholder="Enter registration number" required>
                                        @error('company_registration_number')
                                            <span class="invalid-feedback">{{ $message }}</span>
                                        @enderror
                                    </div>

                                    <div class="form-group">
                                        <label for="company_email">
                                            <i class="fas fa-envelope mr-1"></i>Company Email
                                        </label>
                                        <input type="email" id="company_email" name="company_email" 
                                               class="form-control @error('company_email') is-invalid @enderror"
                                               value="{{ old('company_email', $settings->company_email) }}" 
                                               placeholder="Enter email address" required>
                                        @error('company_email')
                                            <span class="invalid-feedback">{{ $message }}</span>
                                        @enderror
                                    </div>

                                    <div class="form-group">
                                        <label for="website">
                                            <i class="fas fa-globe mr-1"></i>Website
                                        </label>
                                        <input type="url" id="website" name="website" 
                                               class="form-control @error('website') is-invalid @enderror"
                                               value="{{ old('website', $settings->website) }}" 
                                               placeholder="https://example.com" required>
                                        @error('website')
                                            <span class="invalid-feedback">{{ $message }}</span>
                                        @enderror
                                    </div>
                                </div>
                            </div>
                        </div>

                        <!-- System Configuration Card -->
                        <div class="col-md-6">
                            <div class="card card-info">
                                <div class="card-header">
                                    <h3 class="card-title">
                                        <i class="fas fa-cog mr-2"></i>System Configuration
                                    </h3>
                                </div>
                                <div class="card-body">
                                    <div class="form-group">
                                        <label for="time_zone">
                                            <i class="fas fa-clock mr-1"></i>Time Zone
                                        </label>
                                        <select id="time_zone" name="time_zone" 
                                                class="form-control select2 @error('time_zone') is-invalid @enderror" required>
                                            <option value="Asia/Bahrain" {{ $settings->time_zone == 'Asia/Bahrain' ? 'selected' : '' }}>
                                                Asia/Bahrain (GMT+3)
                                            </option>
                                            <option value="Asia/Dhaka" {{ $settings->time_zone == 'Asia/Dhaka' ? 'selected' : '' }}>
                                                Asia/Dhaka (GMT+6)
                                            </option>
                                            <option value="America/New_York" {{ $settings->time_zone == 'America/New_York' ? 'selected' : '' }}>
                                                America/New York (GMT-5)
                                            </option>
                                        </select>
                                        @error('time_zone')
                                            <span class="invalid-feedback">{{ $message }}</span>
                                        @enderror
                                    </div>

                                    <div class="form-group">
                                        <label for="currency">
                                            <i class="fas fa-dollar-sign mr-1"></i>Currency
                                        </label>
                                        <select id="currency" name="currency" 
                                                class="form-control select2 @error('currency') is-invalid @enderror" required>
                                            <option value="USD" {{ $settings->currency == 'USD' ? 'selected' : '' }}>
                                                USD (United States Dollar)
                                            </option>
                                            <option value="BHD" {{ $settings->currency == 'BHD' ? 'selected' : '' }}>
                                                BHD (Bahraini Dinar)
                                            </option>
                                            <option value="BDT" {{ $settings->currency == 'BDT' ? 'selected' : '' }}>
                                                BDT (Bangladeshi Taka)
                                            </option>
                                        </select>
                                        @error('currency')
                                            <span class="invalid-feedback">{{ $message }}</span>
                                        @enderror
                                    </div>

                                    <div class="form-group">
                                        <label for="logo_path">
                                            <i class="fas fa-image mr-1"></i>Company Logo
                                        </label>
                                        @if ($settings->logo_path)
                                            <div class="text-center mb-3">
                                                <img src="{{ asset('logos/' . $settings->logo_path) }}" 
                                                     alt="Company Logo" 
                                                     class="img-thumbnail" 
                                                     style="max-width: 200px; max-height: 150px;">
                                            </div>
                                        @endif
                                        <div class="input-group">
                                            <div class="custom-file">
                                                <input type="file" id="logo_path" name="logo_path" 
                                                       class="custom-file-input @error('logo_path') is-invalid @enderror"
                                                       accept="image/*">
                                                <label class="custom-file-label" for="logo_path">Choose file</label>
                                            </div>
                                        </div>
                                        @error('logo_path')
                                            <span class="invalid-feedback d-block">{{ $message }}</span>
                                        @enderror
                                        <small class="text-muted">Recommended size: 300x200px (JPG, PNG)</small>
                                    </div>
                                </div>
                            </div>

                            <!-- POS Configuration Card -->
                            <div class="card card-warning">
                                <div class="card-header">
                                    <h3 class="card-title">
                                        <i class="fas fa-cash-register mr-2"></i>POS Configuration
                                    </h3>
                                </div>
                                <div class="card-body">
                                    <div class="form-group">
                                        <label for="pos_price_type">
                                            <i class="fas fa-tags mr-1"></i>POS Price Type
                                        </label>
                                        <select id="pos_price_type" name="pos_price_type" 
                                                class="form-control select2 @error('pos_price_type') is-invalid @enderror" required>
                                            <option value="fixed" {{ $settings->pos_price_type == 'fixed' ? 'selected' : '' }}>
                                                Fixed Price
                                            </option>
                                            <option value="percentage" {{ $settings->pos_price_type == 'percentage' ? 'selected' : '' }}>
                                                Percentage (%)
                                            </option>
                                        </select>
                                        @error('pos_price_type')
                                            <span class="invalid-feedback">{{ $message }}</span>
                                        @enderror
                                        <small class="text-muted">Choose how POS pricing should be calculated</small>
                                    </div>

                                    <div class="form-group">
                                        <label for="pos_price_value">
                                            <i class="fas fa-calculator mr-1"></i>POS Price Value
                                        </label>
                                        <div class="input-group">
                                            <input type="number" step="0.01" id="pos_price_value" name="pos_price_value" 
                                                   class="form-control @error('pos_price_value') is-invalid @enderror"
                                                   value="{{ old('pos_price_value', $settings->pos_price_value) }}" 
                                                   placeholder="Enter value" required>
                                            <div class="input-group-append">
                                                <span class="input-group-text" id="price-unit">
                                                    <span class="price-symbol">{{ $settings->currency ?? '$' }}</span>
                                                </span>
                                            </div>
                                        </div>
                                        @error('pos_price_value')
                                            <span class="invalid-feedback">{{ $message }}</span>
                                        @enderror
                                        <small class="text-muted">
                                            <span id="price-help">Enter the fixed amount or percentage value</span>
                                        </small>
                                    </div>
                                </div>
                            </div>
                        </div>
                    </div>

                    <!-- Action Buttons -->
                    <div class="row">
                        <div class="col-12">
                            <div class="card">
                                <div class="card-footer text-right">
                                    <button type="button" class="btn btn-secondary mr-2" onclick="window.history.back()">
                                        <i class="fas fa-arrow-left mr-1"></i>Cancel
                                    </button>
                                    <button type="submit" class="btn btn-success">
                                        <i class="fas fa-save mr-1"></i>Save Settings
                                    </button>
                                </div>
                            </div>
                        </div>
                    </div>
                </form>
            </div>
        </section>
    </div>

    <!-- Page specific scripts -->
    <script>
        $(document).ready(function() {
            // Initialize Select2
            $('.select2').select2({
                theme: 'bootstrap4'
            });

            // Custom file input label update
            $('.custom-file-input').on('change', function() {
                let fileName = $(this).val().split('\\').pop();
                $(this).siblings('.custom-file-label').html(fileName);
            });

            // Update POS price unit display
            function updatePriceUnit() {
                const priceType = $('#pos_price_type').val();
                const currency = $('#currency').val() || '{{ $settings->currency ?? "$" }}';
                
                if (priceType === 'percentage') {
                    $('.price-symbol').text('%');
                    $('#price-help').text('Enter percentage value (e.g., 10 for 10%)');
                } else {
                    $('.price-symbol').text(currency);
                    $('#price-help').text('Enter fixed amount in ' + currency);
                }
            }

            // Initialize price unit display
            updatePriceUnit();

            // Update when price type or currency changes
            $('#pos_price_type, #currency').on('change', updatePriceUnit);
        });
    </script>
@endsection
