@extends('layouts.app')

@section('title', 'WhatsApp Management')

@push('style')
<style>
    .whatsapp-card {
        border-radius: 15px;
        box-shadow: 0 4px 15px rgba(0,0,0,0.1);
        border: none;
    }
    .whatsapp-header {
        background: linear-gradient(135deg, #25d366 0%, #128c7e 100%);
        color: white;
        border-radius: 15px 15px 0 0;
        padding: 20px;
    }
    .country-code-selector {
        background: #f8f9fa;
        border: 1px solid #ced4da;
        border-radius: 5px 0 0 5px;
        padding: 8px 12px;
        font-weight: 600;
        color: #495057;
    }
    .phone-input {
        border-radius: 0 5px 5px 0;
        border-left: none;
    }
    .message-template-card {
        background: #f8f9fa;
        border: 1px solid #e9ecef;
        border-radius: 8px;
        padding: 15px;
        margin-bottom: 15px;
        transition: all 0.3s ease;
    }
    .message-template-card:hover {
        box-shadow: 0 2px 8px rgba(0,0,0,0.1);
        border-color: #25d366;
    }
    .message-preview {
        background: #dcf8c6;
        border-radius: 18px;
        padding: 12px 16px;
        margin: 10px 0;
        font-family: 'Segoe UI', sans-serif;
        font-size: 14px;
        white-space: pre-line;
        position: relative;
        box-shadow: 0 1px 2px rgba(0,0,0,0.1);
    }
    .message-preview::after {
        content: '';
        position: absolute;
        right: -8px;
        bottom: 10px;
        border-left: 8px solid #dcf8c6;
        border-top: 8px solid transparent;
        border-bottom: 8px solid transparent;
    }
    .api-status {
        display: inline-block;
        padding: 4px 12px;
        border-radius: 20px;
        font-size: 12px;
        font-weight: 600;
    }
    .api-status.connected {
        background: #d4edda;
        color: #155724;
        border: 1px solid #c3e6cb;
    }
    .api-status.disconnected {
        background: #f8d7da;
        color: #721c24;
        border: 1px solid #f5c6cb;
    }
    .variable-helper {
        background: #e7f3ff;
        border: 1px solid #b6d7ff;
        border-radius: 5px;
        padding: 10px;
        margin-bottom: 10px;
    }
    .variable-tag {
        background: #007bff;
        color: white;
        border-radius: 4px;
        padding: 2px 8px;
        margin: 2px;
        display: inline-block;
        font-size: 11px;
        cursor: pointer;
        transition: all 0.2s ease;
    }
    .variable-tag:hover {
        background: #0056b3;
        transform: translateY(-1px);
    }
    .toggle-switch {
        position: relative;
        display: inline-block;
        width: 60px;
        height: 34px;
    }
    .toggle-switch input {
        opacity: 0;
        width: 0;
        height: 0;
    }
    .slider {
        position: absolute;
        cursor: pointer;
        top: 0;
        left: 0;
        right: 0;
        bottom: 0;
        background-color: #ccc;
        transition: .4s;
        border-radius: 34px;
    }
    .slider:before {
        position: absolute;
        content: "";
        height: 26px;
        width: 26px;
        left: 4px;
        bottom: 4px;
        background-color: white;
        transition: .4s;
        border-radius: 50%;
    }
    input:checked + .slider {
        background-color: #25d366;
    }
    input:checked + .slider:before {
        transform: translateX(26px);
    }
</style>
@endpush

@section('main')
<div class="content-header">
    <div class="container-fluid">
        <div class="row mb-2">
            <div class="col-sm-6">
                <h1 class="m-0">WhatsApp Management</h1>
            </div>
            <div class="col-sm-6">
                <ol class="breadcrumb float-sm-right">
                    <li class="breadcrumb-item"><a href="{{ route('dashboard') }}">Home</a></li>
                    <li class="breadcrumb-item"><a href="{{ route('invoice-settings.index') }}">Invoice Settings</a></li>
                    <li class="breadcrumb-item active">WhatsApp Management</li>
                </ol>
            </div>
        </div>
    </div>
</div>

<section class="content">
    <div class="container-fluid">
        @if(session('success'))
            <div class="alert alert-success alert-dismissible fade show">
                <i class="fab fa-whatsapp mr-2"></i>{{ session('success') }}
                <button type="button" class="close" data-dismiss="alert" aria-label="Close">
                    <span aria-hidden="true">&times;</span>
                </button>
            </div>
        @endif

        <form action="{{ route('invoice-settings.update') }}" method="POST" id="whatsappForm">
            @csrf
            @method('PUT')
            
            <!-- Include existing settings as hidden fields -->
            <input type="hidden" name="company_name" value="{{ $settings->company_name ?? 'Your Company Name' }}">
            <input type="hidden" name="invoice_header_text" value="{{ $settings->invoice_header_text ?? 'INVOICE' }}">
            <input type="hidden" name="invoice_footer_text" value="{{ $settings->invoice_footer_text ?? '' }}">
            <input type="hidden" name="invoice_template" value="{{ $settings->invoice_template ?? 'default' }}">
            <input type="hidden" name="invoice_terms_conditions" value="{{ $settings->invoice_terms_conditions ?? '' }}">
            
            <div class="row">
                <!-- Connection & QR Settings -->
                <div class="col-md-6">
                    <div class="card whatsapp-card mb-4">
                        <div class="whatsapp-header">
                            <h4 class="mb-0">
                                <i class="fab fa-whatsapp mr-2"></i>WhatsApp QR Code System
                                <span class="api-status" id="connectionStatus">
                                    <i class="fas fa-spinner fa-spin"></i> Checking...
                                </span>
                            </h4>
                        </div>
                        <div class="card-body">
                            <!-- Connection Status Alert -->
                            <div class="alert" id="connectionAlert">
                                <div id="alertContent">
                                    <i class="fas fa-spinner fa-spin mr-2"></i>Checking WhatsApp connection...
                                </div>
                            </div>

                            <div class="form-group">
                                <div class="d-flex justify-content-between align-items-center mb-3">
                                    <label class="mb-0 font-weight-bold">Enable WhatsApp QR Integration</label>
                                    <label class="toggle-switch">
                                        <input type="checkbox" name="whatsapp_enabled" value="1" 
                                               {{ ($settings->whatsapp_enabled ?? true) ? 'checked' : '' }}>
                                        <span class="slider"></span>
                                    </label>
                                </div>
                                <small class="text-muted">Generate QR codes for easy WhatsApp messaging</small>
                            </div>

                            <div class="form-group">
                                <label for="whatsapp_country_code">Default Country Code</label>
                                <div class="input-group">
                                    <div class="input-group-prepend">
                                        <select class="form-control country-code-selector" name="whatsapp_country_code" id="whatsapp_country_code">
                                            <option value="+880" {{ ($settings->whatsapp_country_code ?? '+880') == '+880' ? 'selected' : '' }}>🇧🇩 +880 (Bangladesh)</option>
                                            <option value="+91" {{ ($settings->whatsapp_country_code ?? '') == '+91' ? 'selected' : '' }}>🇮🇳 +91 (India)</option>
                                            <option value="+92" {{ ($settings->whatsapp_country_code ?? '') == '+92' ? 'selected' : '' }}>🇵🇰 +92 (Pakistan)</option>
                                            <option value="+1" {{ ($settings->whatsapp_country_code ?? '') == '+1' ? 'selected' : '' }}>🇺🇸 +1 (USA)</option>
                                            <option value="+44" {{ ($settings->whatsapp_country_code ?? '') == '+44' ? 'selected' : '' }}>🇬🇧 +44 (UK)</option>
                                            <option value="+971" {{ ($settings->whatsapp_country_code ?? '') == '+971' ? 'selected' : '' }}>🇦🇪 +971 (UAE)</option>
                                            <option value="+966" {{ ($settings->whatsapp_country_code ?? '') == '+966' ? 'selected' : '' }}>🇸🇦 +966 (Saudi Arabia)</option>
                                            <option value="+60" {{ ($settings->whatsapp_country_code ?? '') == '+60' ? 'selected' : '' }}>🇲🇾 +60 (Malaysia)</option>
                                            <option value="+65" {{ ($settings->whatsapp_country_code ?? '') == '+65' ? 'selected' : '' }}>🇸🇬 +65 (Singapore)</option>
                                        </select>
                                    </div>
                                    <input type="text" class="form-control phone-input" placeholder="1712345678" readonly>
                                </div>
                                <small class="text-muted">This will be used as default when customer phone numbers don't include country code</small>
                            </div>

                            <div class="form-group">
                                <div class="d-flex justify-content-between align-items-center">
                                    <label class="mb-0">Auto-format Phone Numbers</label>
                                    <label class="toggle-switch">
                                        <input type="checkbox" name="whatsapp_auto_format_numbers" value="1" 
                                               {{ ($settings->whatsapp_auto_format_numbers ?? true) ? 'checked' : '' }}>
                                        <span class="slider"></span>
                                    </label>
                                </div>
                                <small class="text-muted">Automatically add country code to local numbers</small>
                            </div>

                            <div class="alert alert-info">
                                <i class="fas fa-qrcode mr-2"></i>
                                <strong>QR Code System:</strong> No API setup needed! Generate QR codes that customers can scan to send WhatsApp messages directly.
                            </div>

                            <!-- QR Code Demo -->
                            <div class="card bg-light">
                                <div class="card-header">
                                    <h6 class="mb-0"><i class="fas fa-qrcode mr-2"></i>QR Code Demo</h6>
                                </div>
                                <div class="card-body text-center">
                                    <img id="demoQr" src="https://api.qrserver.com/v1/create-qr-code/?size=150x150&data=https://wa.me/8801712345678?text=Hello%20from%20your%20mobile%20store!" 
                                         alt="Demo QR Code" class="img-fluid mb-2" style="max-width: 150px;">
                                    <p class="small text-muted mb-0">Sample QR code for customer messaging</p>
                                    <button type="button" class="btn btn-sm btn-primary mt-2" onclick="generateDemoQr()">
                                        <i class="fas fa-refresh mr-1"></i>Generate New Demo
                                    </button>
                                </div>
                            </div>
                        </div>
                    </div>

                    <!-- QR Code Settings -->
                    <div class="card whatsapp-card">
                        <div class="card-header bg-info">
                            <h5 class="mb-0"><i class="fas fa-cogs mr-2"></i>QR Code Settings</h5>
                        </div>
                        <div class="card-body">
                            <div class="form-group">
                                <label for="qr_code_size">QR Code Size</label>
                                <select class="form-control" id="qr_code_size" name="qr_code_size">
                                    <option value="150">150x150 (Small)</option>
                                    <option value="200" selected>200x200 (Medium)</option>
                                    <option value="300">300x300 (Large)</option>
                                    <option value="400">400x400 (Extra Large)</option>
                                </select>
                                <small class="text-muted">Size of generated QR codes in pixels</small>
                            </div>

                            <div class="form-group">
                                <label for="qr_provider">QR Code Provider</label>
                                <select class="form-control" id="qr_provider" name="qr_provider">
                                    <option value="qrserver" selected>QR Server (Recommended)</option>
                                    <option value="google">Google Charts API</option>
                                </select>
                                <small class="text-muted">Service used to generate QR codes</small>
                            </div>

                            <div class="form-group">
                                <div class="d-flex justify-content-between align-items-center">
                                    <label class="mb-0">Show QR Code in Invoices</label>
                                    <label class="toggle-switch">
                                        <input type="checkbox" name="show_qr_in_invoice" value="1" checked>
                                        <span class="slider"></span>
                                    </label>
                                </div>
                                <small class="text-muted">Include QR code in printed/PDF invoices</small>
                            </div>

                            <div class="form-group">
                                <div class="d-flex justify-content-between align-items-center">
                                    <label class="mb-0">Auto-show QR after Sale</label>
                                    <label class="toggle-switch">
                                        <input type="checkbox" name="auto_show_qr" value="1" 
                                               {{ ($settings->auto_send_whatsapp ?? false) ? 'checked' : '' }}>
                                        <span class="slider"></span>
                                    </label>
                                </div>
                                <small class="text-muted">Automatically display QR code popup after completing sale</small>
                            </div>
                        </div>
                    </div>

                    <!-- Live Testing Section -->
                    <div class="card whatsapp-card mt-4">
                        <div class="card-header bg-warning">
                            <h5 class="mb-0"><i class="fas fa-test-tube mr-2"></i>Live Testing</h5>
                        </div>
                        <div class="card-body">
                            <div class="form-group">
                                <label for="test_phone">Test Phone Number</label>
                                <div class="input-group">
                                    <div class="input-group-prepend">
                                        <span class="input-group-text" id="test-country-code">+880</span>
                                    </div>
                                    <input type="text" class="form-control" id="test_phone" 
                                           placeholder="1712345678" value="1712345678">
                                </div>
                            </div>

                            <div class="form-group">
                                <label for="test_message">Test Message</label>
                                <textarea class="form-control" id="test_message" rows="3" 
                                          placeholder="Enter your test message here...">🎉 Test message from {{ $settings->company_name ?? 'Your Mobile Store' }}!

This is a test WhatsApp message to verify the integration is working properly. 📱

Thank you!</textarea>
                            </div>

                            <div class="row">
                                <div class="col-md-6">
                                    <button type="button" class="btn btn-success btn-block" onclick="testWhatsAppUrl()">
                                        <i class="fab fa-whatsapp mr-2"></i>Test WhatsApp URL
                                    </button>
                                </div>
                                <div class="col-md-6">
                                    <button type="button" class="btn btn-info btn-block" onclick="generateTestQr()">
                                        <i class="fas fa-qrcode mr-2"></i>Generate Test QR
                                    </button>
                                </div>
                            </div>

                            <!-- Test Results -->
                            <div class="mt-3" id="testResults" style="display: none;">
                                <div class="card bg-light">
                                    <div class="card-body">
                                        <h6><i class="fas fa-link mr-2"></i>Generated WhatsApp URL:</h6>
                                        <div class="input-group mb-3">
                                            <input type="text" class="form-control" id="generatedUrl" readonly>
                                            <div class="input-group-append">
                                                <button class="btn btn-outline-secondary" type="button" onclick="copyToClipboard('generatedUrl')">
                                                    <i class="fas fa-copy"></i>
                                                </button>
                                            </div>
                                        </div>
                                        
                                        <h6><i class="fas fa-qrcode mr-2"></i>QR Code:</h6>
                                        <div class="text-center">
                                            <img id="testQrImage" src="" alt="Test QR Code" class="img-fluid" style="max-width: 200px; display: none;">
                                        </div>
                                    </div>
                                </div>
                            </div>
                        </div>
                    </div>
                </div>

                <!-- Message Templates -->
                <div class="col-md-6">
                    <div class="card whatsapp-card mb-4">
                        <div class="card-header bg-success">
                            <h5 class="mb-0"><i class="fas fa-comment-alt mr-2"></i>Message Templates</h5>
                        </div>
                        <div class="card-body">
                            <div class="variable-helper">
                                <strong>Available Variables:</strong><br>
                                <span class="variable-tag" data-variable="{company_name}">Company Name</span>
                                <span class="variable-tag" data-variable="{customer_name}">Customer Name</span>
                                <span class="variable-tag" data-variable="{customer_phone}">Customer Phone</span>
                                <span class="variable-tag" data-variable="{invoice_number}">Invoice Number</span>
                                <span class="variable-tag" data-variable="{invoice_date}">Invoice Date</span>
                                <span class="variable-tag" data-variable="{due_date}">Due Date</span>
                                <span class="variable-tag" data-variable="{item_list}">Item List</span>
                                <span class="variable-tag" data-variable="{currency}">Currency</span>
                                <span class="variable-tag" data-variable="{total_amount}">Total Amount</span>
                                <span class="variable-tag" data-variable="{payment_method}">Payment Method</span>
                                <span class="variable-tag" data-variable="{payment_status}">Payment Status</span>
                                <span class="variable-tag" data-variable="{invoice_link}">Invoice Link</span>
                            </div>

                            <!-- Welcome Message -->
                            <div class="message-template-card">
                                <h6><i class="fas fa-handshake text-primary mr-2"></i>Welcome Message</h6>
                                <textarea class="form-control message-template" name="whatsapp_welcome_message" 
                                          rows="4" placeholder="Welcome message for new customers...">{{ $settings->whatsapp_welcome_message ?? '' }}</textarea>
                                <div class="message-preview" id="welcomePreview"></div>
                            </div>

                            <!-- Invoice Message -->
                            <div class="message-template-card">
                                <h6><i class="fas fa-receipt text-primary mr-2"></i>Invoice Message</h6>
                                <textarea class="form-control message-template" name="whatsapp_invoice_message_template" 
                                          rows="8" placeholder="Invoice message template...">{{ $settings->whatsapp_invoice_message_template ?? '🧾 Invoice #{invoice_number}

👤 Customer: {customer_name}
📞 Phone: {customer_phone}
📅 Date: {invoice_date}

📦 Items:
{item_list}

💰 Total Amount: {currency} {total_amount}
💳 Payment Method: {payment_method}
📊 Payment Status: {payment_status}

🙏 Thank you for your business!

🔗 View full invoice: {invoice_link}' }}</textarea>
                                <div class="message-preview" id="invoicePreview"></div>
                            </div>

                            <!-- Payment Reminder -->
                            <div class="message-template-card">
                                <h6><i class="fas fa-credit-card text-warning mr-2"></i>Payment Reminder</h6>
                                <textarea class="form-control message-template" name="whatsapp_payment_reminder_message" 
                                          rows="4" placeholder="Payment reminder message...">{{ $settings->whatsapp_payment_reminder_message ?? '' }}</textarea>
                                <div class="message-preview" id="reminderPreview"></div>
                            </div>

                            <!-- Delivery Message -->
                            <div class="message-template-card">
                                <h6><i class="fas fa-truck text-info mr-2"></i>Delivery Message</h6>
                                <textarea class="form-control message-template" name="whatsapp_delivery_message" 
                                          rows="4" placeholder="Delivery notification message...">{{ $settings->whatsapp_delivery_message ?? '' }}</textarea>
                                <div class="message-preview" id="deliveryPreview"></div>
                            </div>

                            <!-- Thank You Message -->
                            <div class="message-template-card">
                                <h6><i class="fas fa-heart text-success mr-2"></i>Thank You Message</h6>
                                <textarea class="form-control message-template" name="whatsapp_thank_you_message" 
                                          rows="4" placeholder="Thank you message after purchase...">{{ $settings->whatsapp_thank_you_message ?? '' }}</textarea>
                                <div class="message-preview" id="thankYouPreview"></div>
                            </div>
                        </div>
                    </div>
                </div>
            </div>

            <!-- Action Buttons -->
            <div class="row">
                <div class="col-12">
                    <div class="card">
                        <div class="card-body text-center">
                            <button type="submit" class="btn btn-success btn-lg mr-3">
                                <i class="fab fa-whatsapp mr-2"></i>Save WhatsApp Settings
                            </button>
                            <button type="button" class="btn btn-info btn-lg mr-3" onclick="testQrCode()">
                                <i class="fas fa-qrcode mr-2"></i>Test QR Code
                            </button>
                            <button type="button" class="btn btn-warning btn-lg mr-3" onclick="resetToDefaults()">
                                <i class="fas fa-undo mr-2"></i>Reset to Defaults
                            </button>
                            <a href="{{ route('invoice-settings.index') }}" class="btn btn-secondary btn-lg">
                                <i class="fas fa-arrow-left mr-2"></i>Back to Invoice Settings
                            </a>
                        </div>
                    </div>
                </div>
            </div>
        </form>
    </div>
</section>
@endsection

@push('scripts')
<script>
$(document).ready(function() {
    // Check connection status on page load
    checkWhatsAppConnection();
    
    // Update previews on page load
    updateAllPreviews();

    // Update previews when templates change
    $('.message-template').on('input', function() {
        updateAllPreviews();
    });

    // Variable tag click to insert
    $('.variable-tag').click(function() {
        const variable = $(this).data('variable');
        const activeTextarea = document.activeElement;
        
        if (activeTextarea.tagName === 'TEXTAREA') {
            const cursorPos = activeTextarea.selectionStart;
            const textBefore = activeTextarea.value.substring(0, cursorPos);
            const textAfter = activeTextarea.value.substring(cursorPos);
            
            activeTextarea.value = textBefore + variable + textAfter;
            activeTextarea.selectionStart = activeTextarea.selectionEnd = cursorPos + variable.length;
            activeTextarea.focus();
            
            updateAllPreviews();
        }
    });

    function checkWhatsAppConnection() {
        // For web-based WhatsApp, we don't need API connection
        // Just show that the system is ready
        setTimeout(function() {
            updateConnectionStatus('web-ready');
        }, 1000);
    }

    function updateConnectionStatus(status, deviceInfo = null) {
        const statusSpan = $('#connectionStatus');
        const alertDiv = $('#connectionAlert');
        const alertContent = $('#alertContent');
        
        switch(status) {
            case 'web-ready':
                statusSpan.removeClass().addClass('api-status connected float-right')
                    .html('<i class="fas fa-globe"></i> Web Ready');
                
                alertDiv.removeClass().addClass('alert alert-success');
                alertContent.html(`
                    <i class="fas fa-check-circle mr-2"></i>
                    <strong>WhatsApp Web System Ready!</strong> Your system is configured to use WhatsApp Web URLs and QR codes.
                    <div class="mt-2">
                        <button class="btn btn-sm btn-success mr-2" onclick="testWhatsAppUrl()">
                            <i class="fab fa-whatsapp mr-1"></i>Test Now
                        </button>
                        <button class="btn btn-sm btn-info" onclick="generateTestQr()">
                            <i class="fas fa-qrcode mr-1"></i>Generate QR
                        </button>
                    </div>
                `);
                break;
                
            case 'connected':
                statusSpan.removeClass().addClass('api-status connected float-right')
                    .html('<i class="fas fa-check-circle"></i> Connected');
                
                alertDiv.removeClass().addClass('alert alert-success');
                alertContent.html(`
                    <i class="fas fa-check-circle mr-2"></i>
                    <strong>WhatsApp Connected!</strong> Your device "${deviceInfo?.device_name}" is connected.
                    <a href="{{ route('whatsapp.connect') }}" class="btn btn-sm btn-outline-success ml-2">
                        <i class="fas fa-cogs mr-1"></i>Manage Connection
                    </a>
                `);
                break;
                
            case 'disconnected':
                statusSpan.removeClass().addClass('api-status disconnected float-right')
                    .html('<i class="fas fa-times-circle"></i> Disconnected');
                
                alertDiv.removeClass().addClass('alert alert-warning');
                alertContent.html(`
                    <i class="fas fa-exclamation-triangle mr-2"></i>
                    <strong>WhatsApp Not Connected</strong> - Connect your WhatsApp to send messages directly from your phone.
                    <a href="{{ route('whatsapp.connect') }}" class="btn btn-sm btn-warning ml-2">
                        <i class="fas fa-qrcode mr-1"></i>Connect Now
                    </a>
                `);
                break;
                
            case 'error':
                statusSpan.removeClass().addClass('api-status disconnected float-right')
                    .html('<i class="fas fa-exclamation-circle"></i> Error');
                
                alertDiv.removeClass().addClass('alert alert-danger');
                alertContent.html(`
                    <i class="fas fa-exclamation-circle mr-2"></i>
                    <strong>Connection Error</strong> - Unable to check WhatsApp status.
                    <button class="btn btn-sm btn-danger ml-2" onclick="checkWhatsAppConnection()">
                        <i class="fas fa-refresh mr-1"></i>Retry
                    </button>
                `);
                break;
        }
    }

    // Make checkWhatsAppConnection available globally
    window.checkWhatsAppConnection = checkWhatsAppConnection;

    function updateAllPreviews() {
        updatePreview('whatsapp_welcome_message', 'welcomePreview');
        updatePreview('whatsapp_invoice_message_template', 'invoicePreview');
        updatePreview('whatsapp_payment_reminder_message', 'reminderPreview');
        updatePreview('whatsapp_delivery_message', 'deliveryPreview');
        updatePreview('whatsapp_thank_you_message', 'thankYouPreview');
    }

    function updatePreview(templateName, previewId) {
        let template = $(`textarea[name="${templateName}"]`).val();
        
        if (!template) {
            $(`#${previewId}`).hide();
            return;
        }

        // Replace variables with sample data
        template = template.replace(/{company_name}/g, 'Mobile Store Pro');
        template = template.replace(/{customer_name}/g, 'mahbub');
        template = template.replace(/{customer_phone}/g, '8801612384172');
        template = template.replace(/{invoice_number}/g, '43');
        template = template.replace(/{invoice_date}/g, '10/20/2025');
        template = template.replace(/{due_date}/g, new Date(Date.now() + 30*24*60*60*1000).toLocaleDateString());
        template = template.replace(/{item_list}/g, '• Apple iPhone Xs amx x1 @ BDT 935.00 = BDT 935.00');
        template = template.replace(/{currency}/g, 'BDT');
        template = template.replace(/{total_amount}/g, '935.00');
        template = template.replace(/{payment_method}/g, 'cash');
        template = template.replace(/{payment_status}/g, 'paid');
        template = template.replace(/{invoice_link}/g, 'http://127.0.0.1:8000/sales/43/table-invoice');
        
        $(`#${previewId}`).text(template).show();
    }
});

function generateDemoQr() {
    const countryCode = $('#whatsapp_country_code').val();
    const phone = countryCode.replace('+', '') + '1712345678';
    const message = encodeURIComponent('Hello! I would like to inquire about your mobile phones. 📱');
    const qrUrl = `https://api.qrserver.com/v1/create-qr-code/?size=150x150&data=https://wa.me/${phone}?text=${message}`;
    
    $('#demoQr').attr('src', qrUrl);
    toastr.success('Demo QR code updated with current country code!');
}

function testQrCode() {
    // Create a test QR code popup
    const countryCode = $('#whatsapp_country_code').val();
    const phone = countryCode.replace('+', '') + '1712345678';
    const message = encodeURIComponent('🎉 Test message from ' + ($('#company_name').val() || 'Your Mobile Store') + '!\n\nThis is a test QR code to verify WhatsApp integration is working properly. 📱\n\nThank you!');
    const whatsappUrl = `https://wa.me/${phone}?text=${message}`;
    const qrUrl = `https://api.qrserver.com/v1/create-qr-code/?size=300x300&data=${encodeURIComponent(whatsappUrl)}`;
    
    // Create modal
    const modal = `
        <div class="modal fade" id="qrTestModal" tabindex="-1">
            <div class="modal-dialog modal-dialog-centered">
                <div class="modal-content">
                    <div class="modal-header bg-success text-white">
                        <h5 class="modal-title">
                            <i class="fab fa-whatsapp mr-2"></i>Test QR Code
                        </h5>
                        <button type="button" class="close text-white" data-dismiss="modal">
                            <span>&times;</span>
                        </button>
                    </div>
                    <div class="modal-body text-center">
                        <img src="${qrUrl}" alt="Test QR Code" class="img-fluid mb-3" style="max-width: 300px;">
                        <p class="lead">Scan this QR code with your phone to test!</p>
                        <p class="text-muted">
                            <strong>Phone:</strong> ${phone}<br>
                            <strong>Country:</strong> ${$('#whatsapp_country_code option:selected').text()}
                        </p>
                        <a href="${whatsappUrl}" target="_blank" class="btn btn-success">
                            <i class="fab fa-whatsapp mr-2"></i>Open WhatsApp Web
                        </a>
                    </div>
                    <div class="modal-footer">
                        <button type="button" class="btn btn-secondary" data-dismiss="modal">Close</button>
                        <button type="button" class="btn btn-primary" onclick="downloadQr('${qrUrl}')">
                            <i class="fas fa-download mr-2"></i>Download QR
                        </button>
                    </div>
                </div>
            </div>
        </div>
    `;
    
    // Remove existing modal and add new one
    $('#qrTestModal').remove();
    $('body').append(modal);
    $('#qrTestModal').modal('show');
}

function downloadQr(qrUrl) {
    const link = document.createElement('a');
    link.href = qrUrl;
    link.download = 'whatsapp-qr-test.png';
    link.click();
    toastr.success('QR code download started!');
}

// Live testing functions
function testWhatsAppUrl() {
    const countryCode = $('#whatsapp_country_code').val();
    const phoneNumber = $('#test_phone').val();
    const message = $('#test_message').val();
    
    if (!phoneNumber) {
        toastr.error('Please enter a phone number for testing');
        return;
    }
    
    if (!message.trim()) {
        toastr.error('Please enter a test message');
        return;
    }
    
    // Format phone number
    const fullPhone = countryCode.replace('+', '') + phoneNumber;
    
    // Generate WhatsApp URL
    const whatsappUrl = `https://api.whatsapp.com/send/?phone=${fullPhone}&text=${encodeURIComponent(message)}`;
    
    // Show results
    $('#generatedUrl').val(whatsappUrl);
    $('#testResults').show();
    
    // Open WhatsApp
    window.open(whatsappUrl, '_blank');
    
    toastr.success('WhatsApp opened successfully! Test message URL generated.');
}

function generateTestQr() {
    const countryCode = $('#whatsapp_country_code').val();
    const phoneNumber = $('#test_phone').val();
    const message = $('#test_message').val();
    
    if (!phoneNumber) {
        toastr.error('Please enter a phone number for testing');
        return;
    }
    
    if (!message.trim()) {
        toastr.error('Please enter a test message');
        return;
    }
    
    // Format phone number and create URL
    const fullPhone = countryCode.replace('+', '') + phoneNumber;
    const whatsappUrl = `https://api.whatsapp.com/send/?phone=${fullPhone}&text=${encodeURIComponent(message)}`;
    
    // Generate QR code
    const qrUrl = `https://api.qrserver.com/v1/create-qr-code/?size=300x300&data=${encodeURIComponent(whatsappUrl)}`;
    
    // Show results
    $('#generatedUrl').val(whatsappUrl);
    $('#testQrImage').attr('src', qrUrl).show();
    $('#testResults').show();
    
    toastr.success('Test QR code generated successfully!');
}

function copyToClipboard(elementId) {
    const element = document.getElementById(elementId);
    element.select();
    element.setSelectionRange(0, 99999); // For mobile devices
    
    try {
        document.execCommand('copy');
        toastr.success('URL copied to clipboard!');
    } catch (err) {
        toastr.error('Failed to copy URL');
    }
}

// Update test country code when main country code changes
$(document).ready(function() {
    $('#whatsapp_country_code').on('change', function() {
        $('#test-country-code').text($(this).val());
    });
});

function resetToDefaults() {
    if (confirm('Are you sure you want to reset all WhatsApp templates to defaults? This cannot be undone.')) {
        // Reset all message templates to empty (will trigger defaults from controller)
        $('textarea[name="whatsapp_welcome_message"]').val('');
        $('textarea[name="whatsapp_payment_reminder_message"]').val('');
        $('textarea[name="whatsapp_delivery_message"]').val('');
        $('textarea[name="whatsapp_thank_you_message"]').val('');
        
        // Reset other settings
        $('#whatsapp_country_code').val('+880');
        $('#whatsapp_business_hours').val('9:00 AM - 6:00 PM');
        $('#qr_code_size').val('200');
        $('#qr_provider').val('qrserver');
        
        // Update previews and demo
        updateAllPreviews();
        generateDemoQr();
        
        toastr.info('Templates reset to defaults. Don\'t forget to save!');
    }
}
</script>
@endpush