@extends('layouts.app')

@section('main')
    <div class="container">
        <h2>Edit Direct Sale</h2>
        <form method="POST" action="{{ route('direct-sales.update', $sale->id) }}">
            @csrf
            @method('PUT')
            <div class="form-group">
                <label for="gb">Product Type:</label>
                <select id="product_type" class="form-control" name="product_type" required="">
                    <option value="Accessories" {{ $sale->product_type == 'Accessories' ? 'selected' : '' }}>Accessories
                    </option>
                    <option value="Repair" {{ $sale->product_type == 'Repair' ? 'selected' : '' }}>Repair</option>
                    <option value="Others" {{ $sale->product_type == 'Others' ? 'selected' : '' }}>Others</option>
                </select>
            </div>

            <div class="form-group">
                <label for="sell_price">Sell Price</label>
                <input type="number" class="form-control" name="sell_price"
                    value="{{ old('sell_price', $sale->direct_sell_price) }}" required>
            </div>

            <div class="form-group">
                <label for="cost_price">Cost Price</label>
                <input type="number" class="form-control" name="cost_price"
                    value="{{ old('cost_price', $sale->direct_cost_price) }}" required>
            </div>

            <div class="form-group">
                <label for="profit">Profit</label>
                <input type="number" class="form-control" name="profit" value="{{ old('profit', $sale->direct_profit) }}"
                    required>
            </div>

            <div class="form-group">
                <label for="purchase_note">Purchase Note</label>
                <input type="text" class="form-control" name="purchase_note"
                    value="{{ old('purchase_note', $sale->purchase_note) }}" required>
            </div>

            <div class="form-group">
                <label for="customer_name">Customer Name</label>
                {{-- <input type="text" class="form-control" name="customer_name"
                    value="{{ old('customer_name', $sale->direct_customer_name) }}" required> --}}
                <select id="customer_name" class="form-control" name="customer_name" required="">
                    @foreach ($customers as $customer)
                        <option value="{{ $customer->id }}"
                            {{ $sale->direct_customer_name == $customer->id ? 'selected' : '' }}>
                            {{ $customer->name }}</option>
                    @endforeach
                </select>
            </div>

            <div class="form-group">
                <label for="sold_quantity">Sold Quantity</label>
                <input type="number" class="form-control" name="sold_quantity"
                    value="{{ old('sold_quantity', $sale->direct_sold_quantity) }}" required>
            </div>

            <div class="form-group">
                <label for="date_time">Date & Time</label>
                <input type="datetime-local" class="form-control" name="date_time"
                    value="{{ old('date_time', \Carbon\Carbon::parse($sale->direct_date_time)->format('Y-m-d\TH:i')) }}"
                    required>
            </div>

            <button type="submit" class="btn btn-primary">Update Sale</button>
        </form>
    </div>
@endsection
