@extends('layouts.app')
@push('style')
@endpush
@section('main')
    {{-- {{ $brands }} --}}
    <!-- Content Header (Page header) -->
    <section class="content-header">
        <section class="container-fluid">
            <div class="row mb-2">
                <div class="col-sm-6">
                    <h1>Sales</h1>
                </div>
                <div class="col-sm-6">
                    <ol class="breadcrumb float-sm-right">
                        <li class="breadcrumb-item"><a href="#">Home</a></li>
                        <li class="breadcrumb-item active">Project Add</li>
                    </ol>
                </div>
            </div>
        </section><!-- /.container-fluid -->
        {{-- =============================================== --}}
        @if (session('success'))
            <div class="alert alert-success">
                {{ session('success') }}
            </div>
        @endif
        {{-- =============================================== --}}
    </section>
    {{-- {{ $products }} --}}
    <!-- Main content -->
    <section class="content">
        <div class="card">
            <div class="card-body">
                <div class="row">
                    <div class="col-5">
                        <form method="GET" class="">
                            <label>Select Date Range:</label>
                            <input type="text" name="date_range" id="date_range" class="form-control d-inline w-50"
                                value="{{ request('date_range') }}">
                            <button type="submit" class="btn btn-primary ml-2">Filter</button>
                        </form>
                    </div>
                </div>
                @php
                    $line_total_amount = 0;
                    $total_amount = 0;
                    $total_profit = 0;
                    $line_total_profit = 0;
                @endphp
                <table id="data_table" class="table table-bordered table-striped">
                    <thead>
                        <th>#</th>
                        <th>Customer Name</th>
                        <th>Customer Mobile</th>
                        <th>Brand</th>
                        <th>Model</th>
                        <th>IMEI/SN</th>
                        <th>Selling Price</th>
                        <th>Quantity</th>
                        <th>Total Amount</th>
                        <th>Profit</th>
                        <th>Sale Date</th>
                        <th>Actions</th>
                        </tr>
                    </thead>
                    <tbody>
                        @foreach ($sales as $sale)
                            @php
                                $line_total_amount = $sale->sell_price * $sale->sold_quantity;
                                $line_total_profit = $sale->profit;
                                $total_amount += $line_total_amount;
                                $total_profit += $line_total_profit;
                            @endphp
                            <tr>
                                <td>{{ $sale->id }}</td>
                                <td>{{ htmlspecialchars($sale->customer_name) }}</td>
                                <td>{{ htmlspecialchars($sale->customer_mobile) }}</td>
                                <td>{{ htmlspecialchars($sale->product->brand) }}</td>
                                <td>{{ htmlspecialchars($sale->product->model) }}</td>
                                <td>{{ htmlspecialchars($sale->product->imei_or_sn) }}</td>
                                <td>{{ $all_settings->currency . ' ' . number_format($sale->sell_price, 2) }}</td>
                                <td>{{ $sale->sold_quantity }}</td>
                                <td>{{ $all_settings->currency . ' ' . number_format($line_total_amount, 2) }}
                                </td>
                                <td>{{ $all_settings->currency . ' ' . number_format($line_total_profit, 2) }}</td>
                                <td>{{ $sale->created_at }}</td>
                                <td>
                                    <div class="btn-group">
                                        <button type="button" class="btn btn-danger dropdown-toggle" data-toggle="dropdown"
                                            aria-haspopup="true" aria-expanded="false">
                                            Action
                                        </button>
                                        <div class="dropdown-menu">
                                            {{-- <a class="dropdown-item"
                                                href="{{ route('sales.show', $sale->id) }}">View Sale</a> --}}
                                            <a class="dropdown-item" href="{{ route('sale.invoice', $sale->id) }}">Print
                                                Invoice</a>
                                            <form action="{{ route('sale.destroy', $sale->id) }}" method="POST"
                                                onsubmit="return confirm('Are you sure you want to delete this sale?')">
                                                @csrf
                                                @method('DELETE')
                                                <button type="submit" class="dropdown-item text-danger">Delete</button>
                                            </form>
                                        </div>
                                    </div>
                                </td>
                            </tr>
                        @endforeach
                    </tbody>
                    <tfoot>
                        <tr>
                            <th>#</th>
                            <th>Customer Name</th>
                            <th>Customer Mobile</th>
                            <th>Brand</th>
                            <th>Model</th>
                            <th>IMEI/SN</th>
                            <th>Selling Price</th>
                            <th>Quantity</th>
                            <th>Total Amount</th>
                            <th>Profit</th>
                            <th>Sale Date</th>
                            <th>Actions</th>
                        </tr>
                    </tfoot>
                </table>
                <table id="summary_table" class="table table-bordered table-striped mt-3">
                    <thead>
                        <tr>
                            <th>Total Sale</th>
                            <th>Total Amount</th>
                            <th>Total Profit</th>
                        </tr>
                    </thead>
                    <tbody>
                        <tr>
                            <td id="total_sales">{{ count($sales) }}</td>
                            <td id="total_sell_amount">{{ $all_settings->currency }}
                                {{ number_format($total_amount, 3) }}
                            </td>
                            <td id="total_profit">{{ $all_settings->currency }} {{ number_format($total_profit, 3) }}</td>
                        </tr>
                    </tbody>
                </table>
            </div>

        </div>
    </section>
@endsection

@push('script')
    <script>
        $(function() {
            $("#data_table").DataTable({
                "responsive": true,
                "lengthChange": true,
                "autoWidth": false,
                "lengthMenu": [
                    [10, 50, 100, 500, -1],
                    [10, 50, 100, 500, "All"]
                ],
                "buttons": ["copy", "csv", "excel", "pdf", "print", "colvis"]
            }).buttons().container().appendTo('#example1_wrapper .col-md-6:eq(0)');

        });
        $(document).ready(function() {

            $('#date_range').daterangepicker({
                autoUpdateInput: false,
                locale: {
                    format: 'YYYY-MM-DD'
                }
            }).on('apply.daterangepicker', function(ev, picker) {
                $(this).val(picker.startDate.format('YYYY-MM-DD') + ' - ' + picker.endDate.format(
                    'YYYY-MM-DD'));
            });
        });
    </script>
@endpush
