@extends('layouts.app')
@push('style')
    <style>
        body {
            font-family: 'Roboto', sans-serif;
            background-color: #f9f9f9;
            margin: 0;
            padding: 0;
        }

        h1 {
            text-align: center;
            margin-bottom: 20px;
            color: #333;
        }

        .error-message,
        .success-message {
            font-weight: bold;
            text-align: center;
            margin: 20px 0;
        }

        .error-message {
            color: #e74c3c;
        }

        .success-message {
            color: #2ecc71;
        }

        .invoice {
            width: 60%;
            margin: 20px auto;
            border: 1px solid #ddd;
            padding: 20px;
            background-color: #fff;
            box-shadow: 0 0 10px rgba(0, 0, 0, 0.1);
            text-align: center;
        }

        .invoice h1 {
            font-size: 28px;
            margin-bottom: 15px;
            color: #3498db;
        }

        .invoice p {
            margin: 8px 0;
            font-size: 16px;
        }

        .invoice hr {
            margin: 15px 0;
        }

        .print-btn {
            display: block;
            margin: 25px auto;
            padding: 12px 25px;
            background-color: #2ecc71;
            color: white;
            font-size: 16px;
            border: none;
            cursor: pointer;
            border-radius: 5px;
            transition: background-color 0.3s ease;
        }

        .print-btn:hover {
            background-color: #27ae60;
        }

        form {
            background-color: #fff;
            padding: 30px;
            border-radius: 8px;
            box-shadow: 0 0 10px rgba(0, 0, 0, 0.1);
            margin: 20px auto;
            width: 50%;
        }

        form input,
        form select {
            width: 100%;
            padding: 10px;
            margin: 10px 0;
            border: 1px solid #ddd;
            border-radius: 5px;
        }

        form input[type="submit"] {
            background-color: #3498db;
            color: white;
            cursor: pointer;
            border: none;
            font-size: 16px;
        }

        form input[type="submit"]:hover {
            background-color: #2980b9;
        }

        @media (max-width: 768px) {
            .invoice {
                width: 90%;
            }

            form {
                width: 90%;
            }
        }
    </style>
@endpush
@section('main')
    {{-- {{ $product }} --}}
    <div class="invoice" id="invoice">
        <h1>Quick Phone</h1>
        <p><strong>Date/Time:</strong> {{ date('Y-m-d H:i:s') }}</p>
        <p><strong>Customer Name:</strong> {{ $sale->customer_name }}</p>
        <p><strong>Customer Mobile:</strong> {{ $sale->customer_mobile }}</p>
        <hr>
        <p><strong>Brand:</strong> {{ $product->ProductBrand->name }}</p>
        <p><strong>Model:</strong> {{ $product->ProductModel->name }}</p>
        <p><strong>IMEI/SN:</strong> {{ $product->imei_or_sn }}</p>
        <p><strong>Selling Price (Per Unit):</strong> {{ $sale->sell_price }}</p>
        <p><strong>Quantity Sold:</strong> {{ $sale->sold_quantity }}</p>
        <p><strong>Total Amount:</strong> {{ $sale->sell_price }}</p>
        <p><strong>Warranty:</strong>{{ $sale->warranty }}</p>
        <hr>
        <p>Thank you for shopping at Quick Phone!</p>
    </div>
    <div class="text-center">
        <button onclick='printInvoice()' class='btn btn-primary'>Print Invoice</button>

    </div>
@endsection
@push('script')
    <script>
        function printInvoice() {
            var invoice = document.getElementById('invoice').innerHTML;
            var originalContent = document.body.innerHTML;

            document.body.innerHTML = "<html><head><title>Invoice</title></head><body>" + invoice + "</body></html>";
            window.print();
            document.body.innerHTML = originalContent;
        }
    </script>
@endpush
