@extends('layouts.app')

@section('main')
    <div class="container">
        <h1 class="mb-4">Update Company Settings</h1>

        @if (session('success'))
            <div class="alert alert-success">{{ session('success') }}</div>
        @endif

        <form action="{{ route('settings.update', 1) }}" method="POST" enctype="multipart/form-data">
            @csrf
            @method('PUT')
            <div class="mb-3">
                <label for="company_name" class="form-label">Company Name:</label>
                <input type="text" id="company_name" name="company_name" class="form-control"
                    value="{{ old('company_name', $settings->company_name) }}" required>
            </div>

            <div class="mb-3">
                <label for="time_zone" class="form-label">Time Zone:</label>
                <select id="time_zone" name="time_zone" class="form-control" required>
                    <option value="Asia/Bahrain" {{ $settings->time_zone == 'Asia/Bahrain' ? 'selected' : '' }}>Asia/Bahrain
                        (GMT+3)</option>
                    <option value="Asia/Dhaka" {{ $settings->time_zone == 'Asia/Dhaka' ? 'selected' : '' }}>Asia/Dhaka
                        (GMT+6)</option>
                    <option value="America/New_York" {{ $settings->time_zone == 'America/New_York' ? 'selected' : '' }}>
                        America/New York (GMT-5)</option>
                </select>
            </div>

            <div class="mb-3">
                <label for="currency" class="form-label">Currency:</label>
                <select id="currency" name="currency" class="form-control" required>
                    <option value="USD" {{ $settings->currency == 'USD' ? 'selected' : '' }}>USD (United States Dollar)
                    </option>
                    <option value="BHD" {{ $settings->currency == 'BHD' ? 'selected' : '' }}>BHD (Bahraini Dinar)
                    </option>
                    <option value="BDT" {{ $settings->currency == 'BDT' ? 'selected' : '' }}>BDT (Bangladeshi Taka)
                    </option>
                </select>
            </div>

            <div class="mb-3">
                <label for="logo_path" class="form-label">Upload Logo:</label>
                @if ($settings->logo_path)
                    <div>
                        <img src="{{ asset('logos/' . $settings->logo_path) }}" alt="Company Logo" width="150">
                    </div>
                @endif
                <input type="file" id="logo_path" name="logo_path" class="form-control">
            </div>

            <div class="mb-3">
                <label for="pos_price_type" class="form-label">POS Price Type:</label>
                <select id="pos_price_type" name="pos_price_type" class="form-control" required>
                    <option value="fixed" {{ $settings->pos_price_type == 'fixed' ? 'selected' : '' }}>Fixed Price
                    </option>
                    <option value="percentage" {{ $settings->pos_price_type == 'percentage' ? 'selected' : '' }}>Percentage
                        (%)</option>
                </select>
            </div>

            <div class="mb-3">
                <label for="pos_price_value" class="form-label">POS Price Value:</label>
                <input type="number" step="0.01" id="pos_price_value" name="pos_price_value" class="form-control"
                    value="{{ old('pos_price_value', $settings->pos_price_value) }}" required>
            </div>

            <button type="submit" class="btn btn-primary">Save Settings</button>
        </form>
    </div>
@endsection
