<?php

namespace App\Http\Controllers;

use App\Models\Customer;
use Illuminate\Http\Request;

class CustomerController extends Controller
{
    /**
     * Display a listing of the resource.
     */
    public function index()
    {
        //
    }

    /**
     * Show the form for creating a new resource.
     */
    public function create()
    {
        //
    }

    /**
     * Store a newly created resource in storage.
     */
    public function store(Request $request)
    {
        try {
            // Validate request
            $validatedData = $request->validate([
                'customer_name'   => 'required|string|max:255',
                'customer_number' => 'required|string|max:20',
                'customer_cpr'    => 'nullable|string|max:20',
                'address'         => 'nullable|string|max:255',
            ]);

            // Insert customer into the database
            $customer = Customer::create([
                'name'    => $validatedData['customer_name'],
                'number'  => $validatedData['customer_number'],
                'cpr'     => $validatedData['customer_cpr'] ?? null,
                'address' => $validatedData['address'] ?? null,
            ]);

            // Prepare response data
            $customerInfo = [
                'name'   => $customer->name,
                'number' => $customer->number,
                'cpr'    => $customer->cpr,
            ];

            // Return JSON response
            return response()->json([
                'message'  => 'Customer added successfully',
                'customer' => $customerInfo
            ], 201); // HTTP 201 Created

        } catch (\Illuminate\Validation\ValidationException $e) {
            // Handle validation errors
            return response()->json([
                'message' => 'Validation failed',
                'errors'  => $e->errors(),
            ], 422); // HTTP 422 Unprocessable Entity

        } catch (\Exception $e) {
            // Handle all other exceptions
            return response()->json([
                'message' => 'An error occurred while adding the customer',
                'error'   => $e->getMessage(),
            ], 500); // HTTP 500 Internal Server Error
        }
    }
    /**
     * Display the specified resource.
     */
    public function show(Customer $customer)
    {
        //
    }

    /**
     * Show the form for editing the specified resource.
     */
    public function edit(Customer $customer)
    {
        //
    }

    /**
     * Update the specified resource in storage.
     */
    public function update(Request $request, Customer $customer)
    {
        //
    }

    /**
     * Remove the specified resource from storage.
     */
    public function destroy(Customer $customer)
    {
        //
    }

    public function search(Request $request)
    {
        $query = $request->input('query');

        if (!$query) {
            return response()->json([]);
        }

        // Search by name or number
        $customers = Customer::where('name', 'LIKE', "%{$query}%")
            ->orWhere('number', 'LIKE', "%{$query}%")
            ->take(10)
            ->get(['id', 'name', 'number']);

        return response()->json($customers);
    }
}
