<?php

namespace App\Http\Controllers;

use App\Models\Pos;
use Illuminate\Http\Request;
use Illuminate\Support\Facades\DB;

class PosController extends Controller
{
    /**
     * Display a listing of the resource.
     */
    public function index()
    {
        $brands = [];
        return view('pos.index', compact(['brands']));
    }

    public function fetchProfit(Request $request)
    {
        if ($request->action == 'fetchProfit') {
            // Get today's date
            $today = now()->format('Y-m-d');

            // Fetch profit from sell_transactions
            $profit1 = DB::table('sell_transactions')
                ->whereDate('date_time', $today)
                ->sum('profit');
            $profit1 = $profit1 ?: 0;

            // Fetch profit from direct_sale_report
            $profit2 = DB::table('direct_sales')
                ->whereDate('direct_date_time', $today)
                ->sum('direct_profit');
            $profit2 = $profit2 ?: 0;

            // Total profit
            $total_profit = $profit1 + $profit2;

            // Return response as JSON
            return response()->json([
                'success' => true,
                'total_profit' => $total_profit,
                'profit1' => $profit1,
                'profit2' => $profit2,
                'date' => $today
            ]);
        }
    }

    /**
     * Show the form for creating a new resource.
     */
    public function create()
    {
        //
    }

    /**
     * Store a newly created resource in storage.
     */
    public function store(Request $request)
    {
        //
    }

    /**
     * Display the specified resource.
     */
    public function show(Pos $pos)
    {
        //
    }

    /**
     * Show the form for editing the specified resource.
     */
    public function edit(Pos $pos)
    {
        //
    }

    /**
     * Update the specified resource in storage.
     */
    public function update(Request $request, Pos $pos)
    {
        //
    }

    /**
     * Remove the specified resource from storage.
     */
    public function destroy(Pos $pos)
    {
        //
    }
}
