<?php

namespace App\Http\Controllers;

use App\Models\Brand;
use Illuminate\Http\Request;

class BrandController extends Controller
{
    /**
     * Display a listing of the resource.
     */
    public function index()
    {
        //
    }

    /**
     * Show the form for creating a new resource.
     */
    public function create()
    {
        //
    }

    /**
     * Store a newly created resource in storage.
     */
    public function store(Request $request)
    {
        try {
            // Validate request
            $validatedData = $request->validate([
                'brand_name' => 'required|string|max:20'
            ]);

            // Insert customer into the database
            $brand = Brand::create([
                'name'    => $validatedData['brand_name'],
            ]);

            // Prepare response data
            $brandInfo = [
                'name'   => $brand->name,
            ];

            // // Return JSON response
            // return response()->json([
            //     'message'  => 'Brand added successfully',
            //     'brand' => $brandInfo
            // ], 201); // HTTP 201 Created
            return redirect()->back();
        } catch (\Illuminate\Validation\ValidationException $e) {
            // Handle validation errors
            return response()->json([
                'message' => 'Validation failed',
                'errors'  => $e->errors(),
            ], 422); // HTTP 422 Unprocessable Entity

        } catch (\Exception $e) {
            // Handle all other exceptions
            return response()->json([
                'message' => 'An error occurred while adding the customer',
                'error'   => $e->getMessage(),
            ], 500); // HTTP 500 Internal Server Error
        }
    }

    /**
     * Display the specified resource.
     */
    public function show(Brand $brand)
    {
        //
    }

    /**
     * Show the form for editing the specified resource.
     */
    public function edit(Brand $brand)
    {
        //
    }

    /**
     * Update the specified resource in storage.
     */
    public function update(Request $request, Brand $brand)
    {
        //
    }

    /**
     * Remove the specified resource from storage.
     */
    public function destroy(Brand $brand)
    {
        //
    }
}
