<?php

namespace App\Http\Controllers;

use App\Models\MobileModel;
use Illuminate\Http\Request;

class MobileModelController extends Controller
{
    /**
     * Display a listing of the resource.
     */
    public function index()
    {
        //
    }

    /**
     * Show the form for creating a new resource.
     */
    public function create()
    {
        //
    }

    /**
     * Store a newly created resource in storage.
     */
    public function store(Request $request)
    {
        try {
            // Validate request
            $validatedData = $request->validate([
                'brand_id'   => 'required|integer|exists:brands,id',
                'model_name' => 'required|string|max:20'
            ]);

            // return $validatedData;
            // Insert model into the database
            $model = MobileModel::create([
                'brand_id' => $validatedData['brand_id'], // Ensure brand_id is stored
                'name'     => $validatedData['model_name'],
            ]);

            // Prepare response data
            // return response()->json([
            //     'success' => true,
            //     'message' => 'Model added successfully',
            //     'model'   => [
            //         'id'   => $model->id,
            //         'name' => $model->name,
            //     ]
            // ], 201); // HTTP 201 Created
            return redirect()->back();
        } catch (\Illuminate\Validation\ValidationException $e) {
            // Handle validation errors
            return response()->json([
                'success' => false,
                'message' => 'Validation failed',
                'errors'  => $e->errors(),
            ], 422); // HTTP 422 Unprocessable Entity

        } catch (\Exception $e) {
            // Handle all other exceptions
            return response()->json([
                'success' => false,
                'message' => 'An error occurred while adding the model',
                'error'   => $e->getMessage(),
            ], 500); // HTTP 500 Internal Server Error
        }
    }


    /**
     * Display the specified resource.
     */
    public function show(MobileModel $mobileModel)
    {
        //
    }

    /**
     * Show the form for editing the specified resource.
     */
    public function edit(MobileModel $mobileModel)
    {
        //
    }

    /**
     * Update the specified resource in storage.
     */
    public function update(Request $request, MobileModel $mobileModel)
    {
        //
    }

    /**
     * Remove the specified resource from storage.
     */
    public function destroy(MobileModel $mobileModel)
    {
        //
    }

    public function getModels($brandId)
    {
        try {
            $models = MobileModel::where('brand_id', $brandId)->get();

            return response()->json([
                'success' => true,
                'models' => $models
            ], 200);
        } catch (\Exception $e) {
            return response()->json([
                'success' => false,
                'message' => 'Error fetching models: ' . $e->getMessage()
            ], 500);
        }
    }
}
