@extends('layouts.app')

@section('main')
    <section class="content-header">
        <section class="container-fluid">
            <div class="row mb-2">
                <div class="col-sm-6">
                    <h1>Direct Sales Report</h1>
                </div>

            </div>
        </section>
    </section>
    {{ $sales }}
    <section class="content">
        <div class="card">
            <div class="card-body">
                <!-- Date Range Picker -->
                <div class="row">
                    <div class="col-md-4 mb-2">
                        <label>Select Date Range:</label>
                        <input type="text" name="date_range" id="date_range" class="form-control"
                            placeholder="Select Date Range">
                    </div>
                </div>

                <!-- Table to Display Transactions -->
                <table id="data_table" class="table table-bordered table-striped mt-3">
                    <thead>
                        <tr>
                            <th>#</th>
                            <th>Product Type</th>
                            <th>Purchase Note</th>
                            <th>Sell Price</th>
                            <th>Cost Price</th>
                            <th>Profit</th>
                            <th>Sold Quantity</th>
                            <th>Customer Name</th>
                            <th>Date & Time</th>
                            <th>Actions</th>
                        </tr>
                    </thead>
                    @php
                        $total_sell_amount = 0;
                        $total_profit = 0;
                        
                    @endphp
                    <tbody id="table_body">
                        @foreach ($sales as $sale)
                            @php
                                $total_profit += $sale->direct_profit;
                                $total_sell_amount += $sale->direct_sell_price;
                            @endphp
                            <tr>
                                <td>{{ $sale->id }}</td>
                                <td>{{ $sale->product_type }}</td>
                                <td>{{ $sale->purchase_note }}</td>
                                <td>{{ number_format($sale->direct_sell_price, 2) }}</td>
                                <td>{{ number_format($sale->direct_cost_price, 2) }}</td>
                                <td>{{ number_format($sale->direct_profit, 2) }}</td>
                                <td>{{ $sale->direct_sold_quantity }}</td>
                                <td>{{ $sale->customer ? $sale->customer->name : '-' }}</td>
                                <td>{{ $sale->direct_date_time }}</td>
                                <td>

                                    <div class="btn-group">
                                        <button type="button" class="btn btn-danger dropdown-toggle" data-toggle="dropdown"
                                            aria-haspopup="true" aria-expanded="false">
                                            Action
                                        </button>
                                        <div class="dropdown-menu">
                                            {{-- <a class="dropdown-item"
                                                href="{{ route('sales.show', $sale->id) }}">View Sale</a> --}}
                                            <a class="dropdown-item" href="{{ route('direct-sales.edit', $sale->id) }}">
                                                Edit
                                            </a>
                                            <a class="dropdown-item" target="_blank"
                                                href="{{ route('direct-sales.invoice', $sale->id) }}">
                                                Print Invoice
                                            </a>
                                            <form action="{{ route('direct-sales.destroy', $sale->id) }}" method="POST"
                                                onsubmit="return confirm('Are you sure you want to delete this sale?')">
                                                @csrf
                                                @method('DELETE')
                                                <button type="submit" class="dropdown-item">Delete</button>
                                            </form>
                                        </div>
                                    </div>
                                </td>

                            </tr>
                        @endforeach
                    </tbody>
                </table>

                <table id="summary_table" class="table table-bordered table-striped mt-3">
                    <thead>
                        <tr>
                            <th>Total Sale</th>
                            <th>Total Sale Amount</th>
                            <th>Total Profit</th>
                        </tr>
                    </thead>
                    <tbody>
                        <tr>
                            <td id="total_sales">{{ count($sales) }}</td>
                            <td id="total_profit">{{ $all_settings->currency }} {{ number_format($total_profit, 3) }}</td>
                            <td id="total_sell_amount">{{ $all_settings->currency }}
                                {{ number_format($total_sell_amount, 3) }}
                            </td>
                        </tr>
                    </tbody>
                </table>
            </div>
        </div>
    </section>
@endsection

@push('script')
    <script>
        $(function() {
            $("#data_table").DataTable({
                "responsive": true,
                "lengthChange": true,
                "autoWidth": false,
                "lengthMenu": [
                    [10, 50, 100, 500, -1],
                    [10, 50, 100, 500, "All"]
                ],
                "pageLength": 10, // Default 10 rows per page
                "buttons": ["copy", "csv", "excel", "pdf", "print", "colvis"]
            }).buttons().container().appendTo('#example1_wrapper .col-md-6:eq(0)');
        });

        $(document).ready(function() {
            $('#date_range').daterangepicker({
                autoUpdateInput: false,
                locale: {
                    cancelLabel: 'Clear',
                    format: 'YYYY-MM-DD'
                },
                ranges: {
                    'Today': [moment(), moment()],
                    'Yesterday': [moment().subtract(1, 'days'), moment().subtract(1, 'days')],
                    'Last 7 Days': [moment().subtract(6, 'days'), moment()],
                    'Last 30 Days': [moment().subtract(29, 'days'), moment()],
                    'This Month': [moment().startOf('month'), moment().endOf('month')],
                    'Last Month': [moment().subtract(1, 'month').startOf('month'), moment().subtract(1,
                        'month').endOf('month')],
                    'This Year': [moment().startOf('year'), moment().endOf('year')],
                    'Last Year': [moment().subtract(1, 'year').startOf('year'), moment().subtract(1, 'year')
                        .endOf('year')
                    ],
                    'Custom Range': []
                }
            });

            // When a predefined range is selected
            $('#date_range').on('apply.daterangepicker', function(ev, picker) {
                $(this).val(picker.startDate.format('YYYY-MM-DD') + ' - ' + picker.endDate.format(
                    'YYYY-MM-DD'));
                fetchFilteredData($(this).val());
            });

            // Clear input on cancel
            $('#date_range').on('cancel.daterangepicker', function(ev, picker) {
                $(this).val('');
                fetchFilteredData('');
            });

            function fetchFilteredData(dateRange) {
                $.ajax({
                    url: "{{ route('direct-sales.index') }}", // Ensure this route exists in Laravel
                    type: "GET",
                    data: {
                        date_range: dateRange
                    },
                    success: function(response) {
                        console.log("Response Data:", response);
                        let totalSellAmount = 0;

                        // $('#summary_table').empty();
                        $('#total_sales').text(response.sales.data.length);
                        $('#total_profit').text(response.totalProfit);
                        $('#total_sell_amount').text(response.totalAmount);

                        $('#table_body').empty();
                        // $('#total_profit').text(response.totalProfit);
                        // $('#total_sale').text(response.totalSale);
                        // $('#total_amount').text(response.totalAmount);
                        if (response.sales.data.length > 0) {
                            // $('#table_body').empty();
                            $.each(response.sales.data, function(index, sale) {
                                totalSellAmount += parseFloat(sale.direct_sell_price);

                                $('#table_body').append(`
                                    <tr>
                                        <td>${sale.id}</td>
                                        <td>${sale.product_type}</td>
                                        <td>${sale.purchase_note ?? 'No Notes'}</td>
                                        <td>${sale.direct_sell_price}</td>
                                        <td>${sale.direct_sold_quantity}</td>
                                        <td>${sale.direct_cost_price}</td>
                                        <td>${sale.direct_profit}</td>
                                        <td>${sale.customer ? sale.customer.name : 'N/A'}</td>
                                        <td>${sale.created_at}</td>
                                        <td>
                                            <form action="/direct-sales/${sale.id}" method="POST" onsubmit="return confirm('Are you sure you want to delete this sale?')">
                                                <input type="hidden" name="_token" value="${$('meta[name="csrf-token"]').attr('content')}">
                                                <input type="hidden" name="_method" value="DELETE">
                                                <button type="submit" class="btn btn-danger">Delete</button>
                                            </form>
                                        </td>
                                    </tr>
                                        `);


                            });
                            $('#total_sell_amount').text('{{ $all_settings->currency }} ' +
                                totalSellAmount.toFixed(3));

                        }
                    },
                    error: function(xhr, status, error) {
                        console.error("Error fetching data:", xhr.responseText);
                    }
                });
            }


            // Event Listener for Date Range Picker
            $('#date_range').on('change', function() {
                var dateRange = $(this).val();
                fetchFilteredData(dateRange);
            });

        });
    </script>
@endpush
