<?php

namespace App\Console\Commands;

use Illuminate\Console\Command;
use App\Models\User;
use App\Models\Tenant;
use Illuminate\Support\Facades\Hash;

class CreateAdmin extends Command
{
    protected $signature = 'make:admin {email?} {password?}';
    protected $description = 'Create an admin user';

    public function handle()
    {
        $email = $this->argument('email') ?: 'admin@admin.com';
        $password = $this->argument('password') ?: 'admin123';

        // Create default tenant if it doesn't exist
        $tenant = Tenant::firstOrCreate([
            'domain' => 'main.store'
        ], [
            'name' => 'Main Store',
            'database' => 'main'
        ]);

        // Delete existing admin user if exists
        User::where('email', $email)->delete();

        // Create new admin user
        $admin = User::create([
            'name' => 'Admin',
            'email' => $email,
            'password' => Hash::make($password),
            'tenant_id' => $tenant->id
        ]);

        $this->info('Admin user created successfully!');
        $this->info('Email: ' . $email);
        $this->info('Password: ' . $password);
        $this->info('You can now login at: http://127.0.0.1:8001/login');
    }
}
