<?php

namespace App\Models;

use Illuminate\Database\Eloquent\Factories\HasFactory;
use Illuminate\Database\Eloquent\Model;

class Payment extends Model
{
    use HasFactory;

    // Define the table associated with the model
    protected $table = 'payments';

    // Fillable fields for mass assignment
    protected $fillable = [
        'sale_id',
        'payment_type',
        'amount',
        'tenant_id',
    ];

    // Relationship with the Sale model (a payment belongs to a sale)
    public function sale()
    {
        return $this->belongsTo(Sale::class);
    }

    protected static function booted()
    {
        static::addGlobalScope('tenant', function ($builder) {
            if (app()->has('tenant')) {
                $builder->where('tenant_id', app('tenant')->id);
            }
        });
    }
}
