<?php

use Illuminate\Database\Migrations\Migration;
use Illuminate\Database\Schema\Blueprint;
use Illuminate\Support\Facades\Schema;

return new class extends Migration
{
    /**
     * Run the migrations.
     */
    public function up(): void
    {
        Schema::create('direct_sales', function (Blueprint $table) {
            $table->id();
            $table->string('product_type');
            $table->decimal('direct_cost_price', 10, 2)->nullable();
            $table->decimal('direct_sell_price', 10, 2)->nullable();
            $table->decimal('direct_profit', 10, 2)->nullable();
            $table->integer('direct_sold_quantity')->nullable();
            $table->integer('direct_warranty')->nullable();
            $table->string('direct_customer_name')->nullable();
            $table->dateTime('direct_date_time')->nullable();
            $table->text('purchase_note')->nullable();
            $table->timestamps();
        });
    }

    /**
     * Reverse the migrations.
     */
    public function down(): void
    {
        Schema::dropIfExists('direct_sales');
    }
};
