@extends('layouts.app')

@section('main')
<div class="container-fluid">
    <div class="row">
        <div class="col-12">
            <div class="card">
                <div class="card-header">
                    <h3 class="card-title">Create Tenant</h3>
                </div>
                <div class="card-body">
                    <form action="{{ route('tenants.store') }}" method="POST">
                        @csrf
                        <div class="form-group">
                            <label for="name">Tenant Name</label>
                            <input type="text" class="form-control" id="name" name="name" value="{{ old('name') }}" required>
                        </div>
                        <div class="form-group">
                            <label for="domain">Domain</label>
                            <input type="text" class="form-control" id="domain" name="domain" value="{{ old('domain') }}" required>
                        </div>
                        <div class="form-group">
                            <label for="subdomain">Subdomain (Optional)</label>
                            <input type="text" class="form-control" id="subdomain" name="subdomain" value="{{ old('subdomain') }}">
                        </div>
                        <hr>
                        <h5>Admin User for Tenant</h5>
                        <div class="form-group">
                            <label for="user_name">User Name</label>
                            <input type="text" class="form-control" id="user_name" name="user_name" value="{{ old('user_name') }}" required>
                        </div>
                        <div class="form-group">
                            <label for="user_email">User Email</label>
                            <input type="email" class="form-control" id="user_email" name="user_email" value="{{ old('user_email') }}" required>
                        </div>
                        <div class="form-group">
                            <label for="user_password">Password</label>
                            <input type="password" class="form-control" id="user_password" name="user_password" required>
                        </div>
                        <div class="form-group">
                            <label for="user_password_confirmation">Confirm Password</label>
                            <input type="password" class="form-control" id="user_password_confirmation" name="user_password_confirmation" required>
                        </div>
                        <button type="submit" class="btn btn-primary">Create Tenant</button>
                    </form>
                </div>
            </div>
        </div>
    </div>
</div>
@endsection
